"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.baseMatches = void 0;
var baseIsMatch_1 = require("./baseIsMatch");
var isObject_1 = __importDefault(require("../isObject"));
var keys_1 = __importDefault(require("../keys"));
function baseMatches(source) {
    var matchData = getMatchData(source);
    if (matchData.length === 1 && matchData[0][2]) {
        return matchesStrictComparable(matchData[0][0], matchData[0][1]);
    }
    return function baseMatchesR(obj) {
        return obj === source || (0, baseIsMatch_1.baseIsMatch)(obj, source, matchData, undefined);
    };
}
exports.baseMatches = baseMatches;
function getMatchData(obj) {
    var result = (0, keys_1.default)(obj);
    var length = result.length;
    while (length--) {
        var key = result[length];
        var value = obj[key];
        result[length] = [key, value, isStrictComparable(value)];
    }
    return result;
}
function isStrictComparable(value) {
    return !Number.isNaN(value) && !(0, isObject_1.default)(value);
}
function matchesStrictComparable(key, srcValue) {
    return function matchesStrictComparableR(object) {
        if (object == null) {
            return false;
        }
        return object[key] === srcValue
            && (srcValue !== undefined || (key in Object(object)));
    };
}
