export interface InvokeOptions {
    /**
     * 指定在延迟开始前调用
     */
    leading?: boolean;
    /**
     * 指定在延迟结束后调用
     */
    trailing?: boolean;
}
interface Options extends InvokeOptions {
    /**
     * 设置 func 允许被延迟的最大值
     */
    maxWait?: number;
}
/**
 * 防抖 API，使用如下：
 * 1、生成防抖函数 debounced：debounce(log, 250, { maxWait: 1000 });
 * 2、事件绑定到防抖函数上：addEventListener('resize', debounced);
 * 上面 debounced 在事件每次触发时都会执行，log 是待执行的实际方法 func，在等待时间超过设置的时间下执行，达到防抖作用
 *
 * @param func 待执行的实际方法
 * @param wait 等待时间
 * @param options 设置项，参考 Options 接口定义
 */
declare function debounce(func: Function, wait?: number, options?: Options): {
    (...args: any[]): any;
    flush: () => any;
    cancel: () => void;
    pending: () => boolean;
};
export default debounce;
