"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var baseDiffrence_1 = require("./common/baseDiffrence");
var isArrayLikeObject_1 = __importDefault(require("./isArrayLikeObject"));
/**
 * 从原数组array中去除满足特定条件的元素，生成新数组并返回。该函数不改变原数组
 * @param array，待去除元素的原数组
 * @param valuesAndIteratee，其他数组和iteratee（可选）。如果指定iteratee，则经其判断为true的元素会被去除
 * @return 从原数组中去除特定元素后的新数组
 */
function differenceBy(array) {
    var valuesAndIteratee = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        valuesAndIteratee[_i - 1] = arguments[_i];
    }
    var values = valuesAndIteratee;
    var iteratee;
    var length = valuesAndIteratee.length;
    var lastEle = valuesAndIteratee[length - 1];
    if (!Array.isArray(lastEle)) {
        values = valuesAndIteratee.slice(0, length - 1);
        iteratee = valuesAndIteratee[length - 1];
    }
    values = values.filter(function (v) { return (0, isArrayLikeObject_1.default)(v); });
    if (values.length) {
        values = values.reduce(function (pre, cur) { return __spreadArray(__spreadArray([], __read(pre), false), __read(cur), false); });
    }
    return (0, baseDiffrence_1.baseDifference)(array, values, iteratee, undefined);
}
exports.default = differenceBy;
