import { PredicateParam, PredicateParamFunc } from './common/baseCompare';
/**
 * 该方法类似_.find，区别是该方法返回第一个通过 predicate 判断为真值的元素的索引值（index），而不是元素本身。
 * @param Array (Array): 要搜索的数组。
 * @param predicate (Array|Function|Object|string): 这个函数会在每一次迭代调用。
 * @param fromIndex The index to search from.
 * @returns (number): 返回找到元素的 索引值（index），否则返回 -1。
 */
export default function findIndex(array: Array<any> | null | undefined, predicate?: PredicateParam | PredicateParamFunc, fromIndex?: number): number;
