/**
 * 将`value`转换为有限数。
 *
 * @since 1.0.0
 * @category Lang
 * @param {*} value 待转换的值
 * @returns {number} 转换之后的数字
 * @example
 *```
 * _.toFinite(3.2);
 * // => 3.2
 *
 * _.toFinite(Number.MIN_VALUE);
 * // => 5e-324
 *
 * _.toFinite(Infinity);
 * // => 1.7976931348623157e+308
 *
 * _.toFinite('3.2');
 * // => 3.2
 * ```
 */
export default function toFinite(value: any): number;
