"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isNil_1 = __importDefault(require("./isNil"));
var uniqIdCnt = {};
function uniqueId(prefix) {
    if (prefix === void 0) { prefix = ''; }
    if ((0, isNil_1.default)(uniqIdCnt["".concat(prefix)])) {
        uniqIdCnt["".concat(prefix)] = 0;
    }
    uniqIdCnt["".concat(prefix)] += 1;
    var uniqId = uniqIdCnt["".concat(prefix)];
    // 判断 prefix === `$lodash` 是为了兼容 lodash 实现
    if ("".concat(prefix) === '$lodash$') {
        return "".concat(uniqId);
    }
    return "".concat(prefix).concat(uniqId);
}
exports.default = uniqueId;
