"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseCoverageData = void 0;
const path = require("path");
const fs = require("fs");
const readline = require("readline");
const generateReportForHvigorw_1 = require("../generateReportForHvigorw");
const previewLogPath = '.test/default/intermediates/test/coverage_data/previewer.log';
const coveragePath = '.test/default/intermediates/test/coverage_data/js_coverage.json';
const testResultPath = '.test/default/intermediates/test/coverage_data/test_result.txt';
const dataTag = 'OHOS_REPORT_COVERAGE_DATA: ';
const classTag = 'OHOS_REPORT_STATUS: class=';
const statusBaseTag = 'OHOS_REPORT_STATUS: ';
const stackTag = 'OHOS_REPORT_STATUS: stack=';
const testCaseTag = 'OHOS_REPORT_STATUS: test=';
const statusCodeTag = 'OHOS_REPORT_STATUS_CODE: ';
const resultTag = 'OHOS_REPORT_RESULT: stream=';
let className = '';
let testCaseName = '';
let isStackStatus = false;
let statusBaseIndex = -1;
const parseCoverageData = async (testPreviewerParam) => {
    const Logger = testPreviewerParam.logger;
    const modulePath = testPreviewerParam.modulePath;
    const projectPath = testPreviewerParam.projectPath;
    const previewDirectory = path.join(modulePath, previewLogPath);
    const coverageDirectory = path.join(modulePath, coveragePath);
    const testResultDirectory = path.join(modulePath, testResultPath);
    const isCoverage = testPreviewerParam.coverage === false ? false : true;
    resetStatus();
    const rl = readline.createInterface({
        input: fs.createReadStream(previewDirectory),
        output: process.stdout,
        terminal: false,
    });
    if (fs.existsSync(coverageDirectory)) {
        fs.unlinkSync(coverageDirectory);
    }
    if (fs.existsSync(testResultDirectory)) {
        fs.unlinkSync(testResultDirectory);
    }
    for await (const line of rl) {
        if (logStack(line, Logger, testResultDirectory)
            || logClassAndTestSuite(line, testResultDirectory)
            || logTestResult(line, testResultDirectory)) {
            continue;
        }
        let dataIndex = line.indexOf(dataTag);
        if (dataIndex != -1) {
            let data = line.substring(dataIndex + dataTag.length);
            fs.appendFileSync(coverageDirectory, data, 'utf8');
            continue;
        }
    }
    await generateReport(isCoverage, modulePath, coverageDirectory, projectPath);
};
exports.parseCoverageData = parseCoverageData;
function logStack(line, logger, filePath) {
    let tempStatusBaseIndex = line.indexOf(statusBaseTag);
    if (tempStatusBaseIndex != -1) {
        isStackStatus = line.substring(tempStatusBaseIndex + statusBaseTag.length).startsWith('stack=');
        statusBaseIndex = tempStatusBaseIndex;
    }
    let stackIndex = line.indexOf(stackTag);
    if (stackIndex != -1) {
        let stackContent = line.substring(stackIndex + stackTag.length);
        logger.error(stackContent);
        isStackStatus = true;
        fs.appendFileSync(filePath, stackContent + '\n', 'utf8');
        return true;
    }
    if (isStackStatus) {
        logger.error(line.substring(statusBaseIndex));
        fs.appendFileSync(filePath, line.substring(statusBaseIndex) + '\n', 'utf8');
        return true;
    }
    return false;
}
function logClassAndTestSuite(line, filePath) {
    let classIndex = line.indexOf(classTag);
    if (classIndex != -1) {
        let tempTlassName = line.substring(classIndex + classTag.length);
        if (tempTlassName != className) {
            className = tempTlassName;
            fs.appendFileSync(filePath, `clase=${className}\n`, 'utf8');
        }
        return true;
    }
    let testCaseIndex = line.indexOf(testCaseTag);
    if (testCaseIndex != -1) {
        let tempTestCaseName = line.substring(testCaseIndex + testCaseTag.length);
        if (tempTestCaseName != testCaseName) {
            testCaseName = tempTestCaseName;
            fs.appendFileSync(filePath, `test=${testCaseName}\n`, 'utf8');
        }
        return true;
    }
    return false;
}
function logTestResult(line, filePath) {
    let resultIndex = line.indexOf(resultTag);
    if (resultIndex != -1) {
        let resultContent = line.substring(resultIndex + resultTag.length);
        fs.appendFileSync(filePath, resultContent + '\n', 'utf8');
        return true;
    }
    let statusCodeIndex = line.indexOf(statusCodeTag);
    if (statusCodeIndex != -1) {
        let statusCode = Number.parseInt(line.substring(statusCodeIndex + statusCodeTag.length));
        switch (statusCode) {
            case 0:
                fs.appendFileSync(filePath, 'result=Success\n', 'utf8');
                break;
            case -1:
                fs.appendFileSync(filePath, 'result=Error\n', 'utf8');
                break;
            case -2:
                fs.appendFileSync(filePath, 'result=Failure\n', 'utf8');
                break;
            case -3:
                fs.appendFileSync(filePath, 'result=Ignore\n', 'utf8');
                break;
        }
        return true;
    }
    return false;
}
function resetStatus() {
    className = '';
    testCaseName = '';
    isStackStatus = false;
    statusBaseIndex = -1;
}
async function generateReport(isCoverage, modulePath, coverageDirectory, projectPath) {
    if (!isCoverage) {
        return;
    }
    const initCoveragePath = `${modulePath}/.test/default/intermediates/test/init_coverage.json`;
    if (!fs.existsSync(initCoveragePath)) {
        return;
    }
    const reportPath = `${modulePath}/.test/default/outputs/test/reports`;
    let coverPath = fs.existsSync(coverageDirectory) ? `${coverageDirectory}#${initCoveragePath}` : initCoveragePath;
    await (0, generateReportForHvigorw_1.generateReportForHvigorw)(projectPath, reportPath, coverPath);
}
