"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readInitialCoverage = void 0;
const core_1 = require("@babel/core");
const schema_1 = require("@istanbuljs/schema");
const constants_1 = require("./constants");
// 获取源代码的AST
const getAst = (code) => {
    // 判断code是否已经是AST
    if (typeof code === 'object' && typeof code.type === 'string') {
        return code;
    }
    if (typeof code !== 'string') {
        throw new Error('Code must be a string');
    }
    const res = (0, core_1.parseSync)(code, {
        configFile: false,
        babelrc: false,
        parserOpts: {
            sourceType: 'script',
            allowImportExportEverywhere: true,
            allowAwaitOutsideFunction: true,
            allowReturnOutsideFunction: true,
            allowSuperOutsideMethod: true,
            plugins: schema_1.defaults.instrumenter.parserPlugins,
        },
    });
    return res;
};
const readInitialCoverage = (code) => {
    const ast = getAst(code);
    let scopeCov;
    (0, core_1.traverse)(ast, {
        ObjectProperty(path) {
            const { node } = path;
            if (!node.computed &&
                path.get('key').isIdentifier() &&
                node.key.name === constants_1.Encryption.key) {
                const val = path.get('value').evaluate();
                if (!val.confident || val.value !== constants_1.Encryption.val) {
                    return;
                }
                scopeCov =
                    path.scope.getFunctionParent() || path.scope.getProgramParent();
                path.stop();
            }
        },
    });
    if (!scopeCov) {
        return null;
    }
    const res = {};
    for (const i of ['path', 'hash', 'gcv', 'coverageData']) {
        const binding = scopeCov.getOwnBinding(i);
        if (!binding) {
            return null;
        }
        const valPath = binding.path.get('init');
        const val = valPath.evaluate();
        if (!val.confident) {
            return null;
        }
        res[i] = val.value;
    }
    delete res.coverageData[constants_1.Encryption.key];
    delete res.coverageData.hash;
    return res;
};
exports.readInitialCoverage = readInitialCoverage;
