/// <reference types="node" />
import { LogEvent } from '@ohos/hvigor-arkts-base';
import { MessagePort } from 'worker_threads';
import { CompileEvent } from './analyzer/compile-event.js';
import { CacheStoreManager } from './util/cache-store-type.js';
import { OhosLogger } from './util/log.js';
import { ProjectConfig } from './util/project-config.js';
export interface ArktsCompileResult {
    compileLogEvents: LogEvent[];
    compileEvents: CompileEvent[];
    isSuccess: boolean;
    error?: Error;
}
/**
 * runArkPack 对外接口
 */
export declare function runArkPack(projectConfig: ProjectConfig, errorCallback: Function, handleLogs?: (logs: LogEvent[], lastReUsedFiles?: Set<string>) => void, parentPort?: MessagePort, logger?: OhosLogger, cacheStoreManager?: CacheStoreManager): Promise<ArktsCompileResult>;
export declare function getResolveModules(projectConfig: ProjectConfig): string[];
/**
 * read loader/loader.json
 */
export declare function loadAceBuildJson(aceBuildJsonPath: string | undefined): any;
export { compileCodeSnippet } from './work-scripts/compile-code-snippet.js';
export declare function watch(projectConfig: ProjectConfig, errorCallback: Function, handleLogs: (logs: LogEvent[], lastReUsedFiles?: Set<string>) => void, parentPort?: MessagePort, logger?: OhosLogger): Promise<ArktsCompileResult>;
