import { Level } from 'log4js';
import { AnalyzeMode } from './constants.js';
import { ObfuscationOptions } from './obfuscation-options.js';
export declare type ModuleInfoType = {
    moduleName: string;
    modulePkgPath: string;
};
export declare type ArkCompileProjectModelType = Record<string, ModuleInfoType>;
export interface ProjectConfig {
    /**
     * target名
     */
    targetName: string;
    /**
     * buildProfile路径
     */
    buildGeneratedProfilePath: string;
    /**
     * 当前工程的runtimeOS
     */
    runtimeOS: string;
    /**
     * 当前工程的sdkInfo
     */
    sdkInfo: string;
    /**
     * 当前工程使用的api
     */
    apiVersion: number;
    /**
     * 日志的级别
     */
    level?: Level;
    /**
     * 当前编译任务所属模块到ets目录的路径,例如：entry/src/main/ets
     */
    projectPath?: string;
    /**
     * 是否是watch模式 字符串格式 'true' | 'false'
     */
    watchMode?: 'true' | 'false';
    /**
     * 当前编译任务的abilityType，仅限fa模型存在
     */
    abilityType?: string;
    /**
     * resourceTable.txt的路径
     */
    appResource?: string;
    /**
     * 编译资源的产物中rawfile的路径
     */
    rawFileResource?: string;
    /**
     * 当前编译任务所属模块到ets目录的路径,例如：entry/src/main/ets
     */
    aceModuleRoot: string;
    /**
     * 当前编译任务的build目录
     */
    aceModuleBuild?: string;
    /**
     * 当前编译任务的manifest.json的路径
     */
    aceManifestPath?: string;
    /**
     * 当前编译任务的profile路径
     */
    aceProfilePath?: string;
    /**
     * 当前编译任务的module.json的路径
     */
    aceModuleJsonPath?: string;
    /**
     * 编译任务中低代码的路径
     */
    aceSuperVisualPath?: string;
    /**
     * 当前编译任务loader.json的路径
     */
    aceBuildJson?: string;
    /**
     * 当前编译任务中so文件的路径
     */
    aceSoPath?: string;
    /**
     * local.properties的路径
     */
    localPropertiesPath?: string;
    /**
     * projectProfile文件的路径
     */
    projectProfilePath?: string;
    /**
     * 编译任务缓存的路径
     */
    cachePath?: string;
    /**
     * 是否为预览模式
     */
    isPreview?: boolean;
    /** isOhosTest
     * 是否是 ohosTest
     */
    isOhosTest?: boolean;
    /**
     * mock相关参数
     */
    mockParams?: {
        /**
         * mock 装饰器名称
         */
        decorator: string;
        /**
         * mock 三方包完整包名
         */
        packageName: string;
        /**
         * src/main/ets
         */
        etsSourceRootPath: string;
        /**
         * mock 配置文件的路径,文件不存在时赋值 undefined
         */
        mockConfigPath: string | undefined;
    };
    /**
     * aceCompileMode
     */
    aceCompileMode?: string;
    /**
     * 当前编译任务所属模块的根路径
     */
    modulePath: string;
    /**
     * 工程的根路径
     */
    projectTopDir: string;
    /**
     * 编译工程使用的 sdk中的 ets-loader 根路径
     */
    etsLoaderPath: string;
    /**
     * debug or release
     */
    buildMode?: string;
    /**
     * jsbundle,esmodule
     */
    compileMode?: string;
    /**
     * ohpm/npm
     */
    packageManagerType: 'ohpm' | 'npm';
    /**
     * 描述是否单独编译卡片
     * true为调用卡片编译, false和undefined为调用page页面编译
     */
    widgetCompile?: 'true' | 'false';
    /**
     * 是否支持分chunks，默认为true
     */
    supportChunks: true | false;
    /**
     * 测试框架
     * testMode 测试模式ohosTest|unitTest
     * coveragePathFilter 覆盖率路径过滤
     * coverageMode 覆盖插桩模式：黑白盒
     */
    testFrameworkPar?: {
        testMode?: string;
        coveragePathFilter?: string;
        coverageMode?: 'black' | 'white';
    };
    /**
     * 是否需要进行代码覆盖率插装
     * true是，false否
     */
    needCoverageInsert?: boolean;
    /**
     * compileSdkVersion
     */
    compileSdkVersion?: number;
    /**
     * compatibleSdkVersion
     */
    compatibleSdkVersion?: number;
    /**
     * 当前工程的bundleName
     */
    bundleName?: string;
    /**
     * ets-loader的版本号
     */
    etsLoaderVersion: string;
    /**
     * etsLoader的ReleaseType
     */
    etsLoaderReleaseType?: string;
    /**
     * appResource字段对应的文件的hash值
     */
    resourceTableHash?: string;
    /**
     * aot编译的参数
     */
    aotCompileMode?: string;
    /**
     * 要编译的entry模块的moduleName
     */
    entryModuleName?: string;
    /**
     * 所有模块的moduleName拼接起来的hash
     */
    allModuleNameHash?: string | undefined;
    /**
     * 当前工程的工程模型，用于模块化编译时文件信息的解析，key是模块路径，value是模块的信息
     */
    projectModel?: ArkCompileProjectModelType;
    /**
     * 当前工程中所有模块、工程级别package.json的hash值
     */
    pkgJsonFileHash?: string;
    /**
     * 当前工程需要支持的依赖查找、路径解析的路径集合
     */
    resolveModulePaths: string[];
    /**
     * 三方API根路径, 传递hms闭源及三方sdk API
     * 根路径下sdkconfig.json承载sdk内API配置, 由ets-loader解析
     */
    externalApiPaths: string[];
    /**
     * 经过est-loader解析过的三方API路径集合
     */
    globalModulePaths?: string[];
    /**
     * 当前工程自定义的types的相对路径
     */
    compilerTypes?: string[];
    /**
     * 跨平台工程标识
     */
    isCrossplatform?: boolean | undefined;
    /**
     * 扩展插件路径
     */
    hvigorPluginFile?: string;
    /**
     * ark混淆相关配置
     */
    obfuscationOptions?: ObfuscationOptions;
    /**
     * 是否在主线程编译
     */
    isMainThread?: boolean;
    /**
     * 创建一个新的CompileEvent事件，开始事件
     *
     * @param eventName 事件名
     */
    startEvent?: (eventName: string) => string;
    /**
     * 结束一个已有的CompileEvent事件
     *
     * @param eventId 事件id
     */
    endEvent?: (eventId: string) => void;
    /**
     * 是否需要性能打点
     */
    perf: AnalyzeMode;
    /**
     * 是否支持debugLine
     */
    debugLine?: string;
    /**
     * 是否需要生成全量sourcemap
     */
    needCompleteSourcesMap?: boolean;
    /**
     * 是否是FA模型
     */
    isFaMode: boolean;
}
