import { SdkInfoHandler } from './sdk-info-handler';
import { PathAndApiVersion } from './path-and-apiversion';
import { Component } from './component';
import { SdkSettings } from '../domain/sdk-settings';
import { ErrorTip } from './error-tip';
import { Progress } from '../log/progress';
import { License } from '../license/license-manager';
import { ComponentTask } from '../task/component-task';
export declare abstract class CommonSdkInfoHandler implements SdkInfoHandler {
    protected sdkSettings: SdkSettings;
    protected constructor(sdkSettings: SdkSettings);
    getLocalSdks(): Map<PathAndApiVersion, Component>;
    getOrDownload(pathAndApiVersions: PathAndApiVersion[]): Promise<Map<PathAndApiVersion, Component>>;
    /**
     * doGetOrDownload
     *
     * @param pathAndApiVersions
     * @param localSdks
     * @param downConsumer
     * @protected
     */
    protected doGetOrDownload(pathAndApiVersions: PathAndApiVersion[], localSdks: Map<PathAndApiVersion, Component>, downConsumer?: (component: Component) => void): Promise<Map<PathAndApiVersion, Component>>;
    private _filterRequiredSdks;
    private _findMissingComponents;
    private _downloadComponents;
    private _checkLicense;
    private _installComponents;
    private _throwNotFoundException;
    protected getNotFoundException(): string;
    private _decoratePath;
    private _mergeComponents;
    protected mapComponents(components: Component[]): Map<PathAndApiVersion, Component>;
    /**
     * 加载本地的sdk
     * @protected
     * @return
     */
    protected abstract getLocalComponents(): Component[];
    /**
     * 加载远程的sdk
     * @protected
     * @return
     */
    protected abstract getRemoteComponents(): Promise<Component[]>;
    /**
     * getProgress
     *
     * @protected
     */
    protected abstract getProgress(): Progress;
    /**
     * 查询未接受的license
     * @param components
     * @protected
     */
    protected abstract findUnacceptedLicenses(components: Component[]): Promise<License[] | undefined>;
    /**
     * 获取license未接受时的报错信息
     * @param fullNameList
     * @protected
     */
    protected abstract getLicenseNotAcceptedMessage(fullNameList: string[]): ErrorTip;
    /**
     * 创建install task
     *
     * @param component
     * @protected
     */
    protected abstract createInstallComponentTask(component: Component): ComponentTask;
}
