export interface Component extends Comparable<Component> {
    getPath(): string;
    getVersion(): string;
    getApiVersion(): number;
    getReleaseType(): string;
    getDisplayName(): string;
    getLocation(): string | undefined;
    hasApiVersion(): boolean;
    getMeta(): Meta | undefined;
    getArchive(): Archive | undefined;
    getLicense(): string;
    getFullName(): string;
}
export interface Meta {
    getMetaVersion(): string;
}
export interface Comparable<T> {
    compareTo(other: T): number;
}
export interface Archive {
    getUrl(): string | undefined;
    getSize(): number;
    getChecksum(): string;
    getOsType(): string;
}
