"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ErrorTip = void 0;
const os = __importStar(require("os"));
const utils_1 = require("../util/utils");
class ErrorTip {
    constructor(msg = '', reason, fixSuggestion) {
        this._msg = msg;
        this._reason = reason;
        this._fixSuggestion = fixSuggestion;
    }
    /**
     * 原因
     */
    getReason() {
        return this._reason;
    }
    /**
     * 解决措施
     */
    getFixSuggestion() {
        return this._fixSuggestion;
    }
    /**
     * 获取标准格式的错误信息
     */
    getMessage() {
        if ((0, utils_1.isEmpty)(this._msg)) {
            return `Cause: ${this._reason}${os.EOL}Solution: ${this._fixSuggestion}`;
        }
        return `${this._msg}${os.EOL}Cause: ${this._reason}${os.EOL}Solution: ${this._fixSuggestion}`;
    }
}
exports.ErrorTip = ErrorTip;
ErrorTip.EMPTY = new ErrorTip('', '', '');
