import { SimpleProgress } from '../log/simple-progress';
import { Component } from '../api/component';
import { AbstractComponentLoader } from './abstract-component-loader';
export declare abstract class AbstractLocalComponentLoader extends AbstractComponentLoader {
    /**
     * 临时文件夹
     * @private
     */
    private readonly _TEMP_PREFIX;
    /**
     * 扫描的最大深度
     * @private
     */
    private readonly _maxScanDepth;
    /**
     * sdk根路径
     * @private
     */
    protected readonly sdkRoot: string;
    protected constructor(maxScanDepth: number, sdkRoot: string, progress?: SimpleProgress);
    /**
     * 加载本地的sdk
     */
    load(): Component[];
    /**
     * 将扫描到的文件转换为Component
     * @param potentialUniPackages
     * @protected
     */
    protected abstract parseSdks(potentialUniPackages: string[]): Component[];
    /**
     * 获取元数据文件名称
     * @protected
     */
    protected abstract getUniPackageName(): string;
    /**
     * getSdkRoot
     * @protected
     */
    protected abstract getSdkRoot(): string;
    /**
     * 使用非递归方式扫描指定sdk根路径下潜在的sdk元数据文件
     * @param root
     * @protected
     */
    protected findPotentialSdks(root: string): string[];
    private _needScan;
}
