"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommonNetClient = void 0;
const https_util_1 = require("../util/https-util");
const fs_1 = __importDefault(require("fs"));
const sdk_exception_1 = require("../api/sdk-exception");
const error_tip_1 = require("../api/error-tip");
class CommonNetClient {
    constructor(proxyInfo) {
        this.saveToFile = (saveLocation, response) => __awaiter(this, void 0, void 0, function* () {
            yield fs_1.default.promises.writeFile(saveLocation, response.data, 'binary').catch(error => {
                throw new sdk_exception_1.SdkException('', new error_tip_1.ErrorTip('', `Failed to store the SDK during download, ${error.message}`, ''));
            });
            return Promise.resolve();
        });
        this._axiosInstance = (0, https_util_1.createAxiosInstance)(proxyInfo);
    }
    /**
     * post请求
     *
     * @param url url地址
     * @param progress 进度条
     * @param param 请求参数信息
     * @param header 请求头信息
     * @return result 可以指定返回的数据类型,
     * 需要注意的是如果需要对结果进行JSON.parse的话，需要先进行JSON.stringify，否则会报错
     * 如果请求失败返回undefined
     */
    doPost(url, progress, param, header) {
        return __awaiter(this, void 0, void 0, function* () {
            let response;
            try {
                response = yield this._axiosInstance.post(url, param, { headers: header });
                return response.data;
            }
            catch (e) {
                progress.warn(e === null || e === void 0 ? void 0 : e.message);
                progress.warn(`url=${url}, statusCode=${response === null || response === void 0 ? void 0 : response.status}`);
            }
            return undefined;
        });
    }
    /**
     * get请求下载操作
     *
     * @param url 下载地址
     * @param downloadLocation 下载到本地的文件路径
     * @param progress 进度条
     * @throws SdkException 如果下载时存储文件的操作失败了就抛这个异常
     * @return 下载成功返回true，如果是网络请求失败了就返回false
     */
    doGetDownload(url, downloadLocation, progress) {
        return __awaiter(this, void 0, void 0, function* () {
            let response;
            try {
                response = yield this._axiosInstance.get(url, { responseType: 'stream' });
            }
            catch (e) {
                progress.warn(e === null || e === void 0 ? void 0 : e.message);
                progress.warn(`url=${url}, statusCode=${response === null || response === void 0 ? void 0 : response.status}`);
                return false;
            }
            yield this.saveToFile(downloadLocation, response);
            return true;
        });
    }
    /**
     * post请求下载操作
     *
     * @param url 下载地址
     * @param downloadLocation 下载到本地的文件路径
     * @param progress 进度条
     * @param param 请求参数
     * @param header 请求头
     * @throws SdkException 如果下载时存储文件的操作失败了就抛这个异常
     * @return 下载成功返回true，如果是网络请求失败了就返回false
     */
    doPostDownload(url, downloadLocation, progress, param, header) {
        return __awaiter(this, void 0, void 0, function* () {
            let response;
            try {
                response = yield this._axiosInstance.post(url, param, { headers: header, responseType: 'stream' });
            }
            catch (e) {
                progress.warn(e === null || e === void 0 ? void 0 : e.message);
                progress.warn(`url=${url}, statusCode=${response === null || response === void 0 ? void 0 : response.status}`);
                return false;
            }
            yield this.saveToFile(downloadLocation, response);
            return true;
        });
    }
    /**
     * get请求
     *
     * @param url 请求地址
     * @param progress 进度条
     * @return result 可以指定返回的数据类型
     * 需要注意的是如果需要对结果进行JSON.parse的话，需要先进行JSON.stringify，否则会报错
     * 如果请求失败返回undefined
     */
    doGet(url, progress) {
        return __awaiter(this, void 0, void 0, function* () {
            let response;
            try {
                response = yield this._axiosInstance.get(url);
                return response.data;
            }
            catch (e) {
                progress.warn(e === null || e === void 0 ? void 0 : e.message);
                progress.warn(`url=${url}, statusCode=${response === null || response === void 0 ? void 0 : response.status}`);
            }
            return undefined;
        });
    }
}
exports.CommonNetClient = CommonNetClient;
