"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SingleTaskWrapper = void 0;
const path_1 = __importDefault(require("path"));
const fs_1 = __importStar(require("fs"));
const sdk_exception_1 = require("../api/sdk-exception");
const abstract_component_task_1 = require("./abstract-component-task");
const file_util_1 = require("../util/file-util");
class SingleTaskWrapper extends abstract_component_task_1.AbstractComponentTask {
    constructor(componentTask) {
        super(componentTask.getComponent());
        this.LCK = '.op.lock';
        this.execute = (progress) => __awaiter(this, void 0, void 0, function* () {
            let fd = -1;
            const lockFile = path_1.default.resolve(this.getWorkDir(), this.LCK);
            let shouldDeleteLockFile = true;
            try {
                yield (0, file_util_1.ensureParentDirAsync)(lockFile);
                fd = fs_1.default.openSync(lockFile, fs_1.constants.O_CREAT | fs_1.constants.O_EXCL | fs_1.constants.O_RDWR);
                yield this._componentTask.execute(progress);
            }
            catch (error) {
                if (error instanceof sdk_exception_1.SdkException) {
                    throw error; // 如果是自定义的异常,则代表不是由于文件锁导致的原因
                }
                shouldDeleteLockFile = false;
                progress.warn(error === null || error === void 0 ? void 0 : error.message);
                throw new sdk_exception_1.SdkException('', this.getDuplicateTaskErrorTip(lockFile));
            }
            finally {
                this._releaseLock(progress, lockFile, shouldDeleteLockFile, fd);
            }
        });
        this._releaseLock = (progress, lockFile, shouldDeleteLockFile, fd) => {
            if (!shouldDeleteLockFile) {
                return;
            }
            this._closeLock(fd, progress);
            try {
                fs_1.default.rmSync(lockFile, { recursive: true });
                this._cleanWorkDirWhenEmpty();
            }
            catch (error) {
                progress.warn(`Unable to delete temp work file. You can delete it manually. ${error.message}`);
            }
        };
        this._closeLock = (fd, progress) => {
            if (!this._isLockValid(fd)) {
                return;
            }
            try {
                fs_1.default.closeSync(fd);
            }
            catch (error) {
                progress.warn(`Unable to close lock file, ${error === null || error === void 0 ? void 0 : error.message}`);
            }
        };
        this._isLockValid = (fd) => {
            return fd !== -1;
        };
        this._cleanWorkDirWhenEmpty = () => {
            const workDir = this.getWorkDir();
            const rootWorkDir = this.getRootWorkDir();
            for (let parent = workDir; parent && parent.includes(rootWorkDir); parent = path_1.default.dirname(parent)) {
                if (fs_1.default.existsSync(parent)) {
                    (0, fs_1.rmSync)(parent, { recursive: true });
                }
            }
        };
        this._componentTask = componentTask;
    }
    getComponent() {
        return this._componentTask.getComponent();
    }
    getSdkRoot() {
        return this._componentTask.getSdkRoot();
    }
}
exports.SingleTaskWrapper = SingleTaskWrapper;
