"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpsProxyAgent = void 0;
const https_1 = __importDefault(require("https"));
const url_1 = require("url");
const http_1 = __importDefault(require("http"));
const tls_1 = __importDefault(require("tls"));
class HttpsProxyAgent extends https_1.default.Agent {
    constructor(options) {
        const { proxy } = options, opts = __rest(options, ["proxy"]);
        super(opts);
        this.proxy = new url_1.URL(proxy);
    }
    createConnection(options, callback) {
        var _a;
        const requestOptions = {
            host: this.proxy.hostname,
            port: this.proxy.port,
            path: `${options.host}:${options.port}`,
            setHost: false,
            method: 'CONNECT',
            headers: { connection: options.keepAlive ? 'keep-alive' : 'close', host: `${options.host}:${options.port}` },
            agent: false,
            timeout: options.timeout || 20000,
        };
        if (this.proxy.username || this.proxy.password) {
            const authorization = Buffer.from(`${decodeURIComponent(this.proxy.username || '')}:${decodeURIComponent(this.proxy.password || '')}`).toString('base64');
            Object.assign((_a = requestOptions.headers) !== null && _a !== void 0 ? _a : {}, { 'proxy-authorization': `Basic ${authorization}` });
        }
        if (this.proxy.protocol === 'https:') {
            requestOptions.servername = this.proxy.hostname;
        }
        const clientRequest = (this.proxy.protocol === 'https:' ? https_1.default : http_1.default).request(requestOptions);
        clientRequest.once('connect', (response, socket, head) => {
            if (response.statusCode === 200) {
                const secureSocket = tls_1.default.connect(Object.assign(Object.assign({}, options), { socket }));
                secureSocket.on('close', () => {
                    secureSocket.destroy();
                });
                callback(null, secureSocket);
            }
            else {
                callback(new Error(`Bad response: ${response.statusCode}`), null);
            }
        });
        clientRequest.once('timeout', () => {
            clientRequest.destroy(new Error('Proxy timeout'));
        });
        clientRequest.once('error', err => {
            callback(err, null);
            clientRequest.destroy();
        });
        clientRequest.end();
    }
}
exports.HttpsProxyAgent = HttpsProxyAgent;
