"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OhPrjSdkConfig = exports.OhPrjSdkType = exports.SimpleOhPrjSdkHandler = void 0;
const oh_sdk_info_handler_1 = require("./oh-sdk-info-handler");
const simple_progress_1 = require("../../core/log/simple-progress");
const sdk_info_config_1 = require("../../core/api/sdk-info-config");
class SimpleOhPrjSdkHandler {
    constructor(OhPrjSdkConfig, progress = new simple_progress_1.SimpleProgress()) {
        this._sdkHandlerMap = new Map();
        this._sdkHandlerMap.set(OhPrjSdkType.OPENHARMONY, new oh_sdk_info_handler_1.OhSdkInfoHandler(OhPrjSdkConfig.getOhSdkConfig(), progress));
    }
    getSdkHandler(OhPrjSdkType) {
        return this._sdkHandlerMap.get(OhPrjSdkType);
    }
}
exports.SimpleOhPrjSdkHandler = SimpleOhPrjSdkHandler;
var OhPrjSdkType;
(function (OhPrjSdkType) {
    OhPrjSdkType[OhPrjSdkType["OPENHARMONY"] = 0] = "OPENHARMONY";
})(OhPrjSdkType = exports.OhPrjSdkType || (exports.OhPrjSdkType = {}));
class OhPrjSdkConfig {
    constructor(sdkRoot) {
        this._ohSdkConfig = sdk_info_config_1.SdkInfoConfig.create(sdkRoot);
    }
    static builder(sdkRoot) {
        return new OhPrjSdkConfig(sdkRoot);
    }
    sdkProxy(proxy) {
        this._ohSdkConfig.setSdkProxy(proxy);
        return this;
    }
    nodeHome(nodeHome) {
        this._ohSdkConfig.setNodeHome(nodeHome);
        return this;
    }
    npmConfig(npmConfig) {
        this._ohSdkConfig.setNpmConfig(npmConfig);
        return this;
    }
    getOhSdkConfig() {
        return this._ohSdkConfig;
    }
}
exports.OhPrjSdkConfig = OhPrjSdkConfig;
