import { FileSet, TaskDetails, TaskInputValue } from '@ohos/hvigor';
import { TargetTaskService } from '../service/target-task-service.js';
import { OhosHarTask } from '../task/ohos-har-task.js';
/**
 * 打包Har包
 *
 * @since 2021/12/18
 */
export declare abstract class AbstractPackageHar extends OhosHarTask {
    protected readonly _moduleDir: string;
    protected readonly taskTmpDir: string;
    protected readonly outputDir: string;
    protected readonly processedLibs: string;
    protected readonly resourceTablePath: string;
    protected readonly harProfile: string;
    protected readonly harModuleJson: string;
    protected readonly npmPath: string;
    protected readonly cmakeListDir: string;
    protected readonly cppTypes: string;
    protected readonly allInvalidPrefix: string[];
    protected readonly npmCommand: string[];
    protected readonly resourceDir: string;
    protected readonly headerPath?: string;
    protected readonly hasNativeOption: boolean;
    protected readonly needCppTypes: boolean;
    protected readonly ignoreFileNames: string[];
    protected readonly ohpmIgnoreRules: string[];
    protected readonly obfuscationFiles: string[];
    protected needCopyFileNames: string[];
    declareExecutionCommand(): string;
    declareExecutionEnv(): Map<string, string>;
    declareInputs(): Map<string, TaskInputValue>;
    declareInputFiles(): FileSet;
    declareOutputFiles(): FileSet;
    protected constructor(taskService: TargetTaskService, taskDetails: TaskDetails);
    private initModuleToplevelPathFilter;
    private initNeedCopyFileNames;
    private initFilterRules;
    abstract copyCompiledSourceFileToTempDir(): void;
    protected doTaskAction(): Promise<void>;
    private syncNativeHeader;
    private syncObfuscationFile;
    private resolveObfuscationFiles;
    private noNeedCopyCmakeList;
    private copyLocalDepsFileToTempDir;
    private copyModuleSourceFileToTempDirByWhiteList;
    private getCopyFilter;
    private needCopyFile;
    /**
     * 过滤混淆配置文件
     *
     * @param src absolute file path
     * @private
     */
    private excludeObfuscationFiles;
    private needIgnoreSrc;
    private copyModuleSourceFileToTempDirByBlackList;
    private preCheckBeforePack;
    private copyBuildIntermediatesOutToTempDir;
    private executeNpmPack;
    private executeOhpmPack;
    protected copyOtherGenerateFiles(): void;
}
