"use strict";var __importDefault=this&&this.__importDefault||function(t){return t&&t.__esModule?t:{default:t}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.PackageApp=void 0;const hvigor_1=require("@ohos/hvigor"),hvigor_2=require("@ohos/hvigor"),fs_extra_1=__importDefault(require("fs-extra")),path_1=__importDefault(require("path")),packing_tool_options_js_1=require("../builder/inner-java-command-builder/packing-tool-options.js"),file_util_js_1=require("../utils/file-util.js"),process_utils_js_1=require("../utils/process-utils.js"),base_pack_app_task_js_1=require("./base/base-pack-app-task.js"),task_names_js_1=require("./common/task-names.js"),generate_pack_res_js_1=require("./generate-pack-res.js");var Task=task_names_js_1.TaskNames.Task;const build_directory_const_js_1=require("../const/build-directory-const.js"),module_task_service_js_1=require("./service/module-task-service.js"),remote_hsp_utils_js_1=require("../utils/remote-hsp-utils.js");class PackageApp extends base_pack_app_task_js_1.BasePackAppTask{constructor(t,e){super(t,e,Task.PACKAGE_APP),this.allDestDir=[],this.allSrcHapPath=[],this.allDestHapPath=[],this.allSrcHspPath=[],this.allDestHspPathList=[],this.allRemoteHspPathMap=new Map,this.remoteHspModuleSet=new Set,this.projectBuildProfilePath="",this.defaultPackageLimitSize=2;const s=this.service.getPathInfo();this.projectBuildProfilePath=e.getProjectModel().getProfilePath(),this.curProduct=e.getTargetProduct(),this.outPath=path_1.default.resolve(s.getProjectOutputPath(),this.service.getAppOutputFileName()),this.service.getProductDataMap().forEach((t=>{for(const e of t){const t=e.getPathInfo().getModuleBuildOutputPath();e.getModuleModel().isHapModule()?this.initWithHapModuleData(e,t):this.initWithHspModuleData(e,t);const s=e.getModuleModel(),a=s.getRemoteHspPath();this.remoteHspModuleSet.has(s.getName())||(this.initRemoteHsp(a),this.remoteHspModuleSet.add(s.getName()))}}));const a=e.getProjectModel().getRemoteHspPath();this.initRemoteHsp(a);[...this.allRemoteHspPathMap.values()].forEach((({hspPath:t})=>{this.allDestHspPathList.push(t)}))}declareExecutionCommand(){return`${this.getPackAppCommand().toString()}`}declareInputs(){return(new Map).set("allDestDir",this.allDestDir)}declareInputFiles(){const t=(new hvigor_2.FileSet).addEntries([this.packInfoPath,...this.allSrcHapPath,...this.allSrcHspPath],{isDirectory:!1});return this.needPackRes&&t.addEntry(this.packResPath,{isDirectory:!0}),t}declareOutputFiles(){return super.declareOutputFiles().addEntries([this.outPath,...this.allDestHapPath,...this.allDestHspPathList],{isDirectory:!1})}initTaskDepends(){this.dependsOn(generate_pack_res_js_1.GeneratePackRes.name)}async doTaskAction(){const t="generate app packaging command",e=this.durationEvent.createSubEvent(t,"");e.start(),await this.getUnpackedHaps();const s=this.getPackAppCommand();this._log._printDebugCommand("PackageApp",s),e.stop(),e.setLog(t,hvigor_1.MetricLogType.INFO);const a="execute app packaging command",i=this.durationEvent.createSubEvent(a,"");i.start(),await(new process_utils_js_1.ProcessUtils).execute(s),i.stop(),i.setLog(a,hvigor_1.MetricLogType.INFO)}getPackAppCommand(){const t=new packing_tool_options_js_1.PackingToolOptions;return t.addCalledJarFile(this.packageTool),this.needPackRes&&fs_extra_1.default.existsSync(this.packResPath)&&t.addPackResPath(this.packResPath),t.addMode("app").addPackInfoPath(this.packInfoPath).addHapPath(this.allDestHapPath.join(",")).addHspPath(this.allDestHspPathList.join(",")).force(!0).addOutPath(this.outPath).addMainModuleLimit(this.defaultPackageLimitSize).addNormalModuleLimit(this.defaultPackageLimitSize),t.build()}async getUnpackedHaps(){for(const t of this.allDestDir)file_util_js_1.FileUtil.checkDirWithoutDelete(t);const t=[],e=[];this.checkOutputName(this.allSrcHapPath);for(let e=0;e<this.allSrcHapPath.length;e++)t.push(fs_extra_1.default.copy(this.allSrcHapPath[e],this.allDestHapPath[e]));this.checkOutputName(this.allSrcHspPath);for(let t=0;t<this.allSrcHspPath.length;t++)e.push(fs_extra_1.default.copy(this.allSrcHspPath[t],this.allDestHspPathList[t]));await Promise.all([...t,...e])}initWithHapModuleData(t,e){const s=t.getModuleTargetOutputFileName("",!1),a=path_1.default.resolve(e,"app");this.allDestDir.push(a);let i=t.getRelatedEntryModules();const l=t.getModuleModel().getModuleType();if(module_task_service_js_1.ModuleTaskService.checkEntryModules(l,i)){this.service.isFaMode()||(i=[i[0]]);for(const s of i){const i=t.getModuleTargetOutputFileName(s,!1),l=path_1.default.resolve(e,i),o=path_1.default.resolve(a,i.replace("-unsigned",""));this.allSrcHapPath.push(l),this.allDestHapPath.push(o)}}else if(t.isSingleDeviceTypeTarget()){const t=path_1.default.resolve(e,s),i=path_1.default.resolve(a,s.replace("-unsigned",""));this.allDestDir.push(a),this.allSrcHapPath.push(t),this.allDestHapPath.push(i)}else t.getTargetDeviceTypeClasses().forEach((s=>{const i=t.getModuleTargetOutputFileName("",!1,void 0,s),l=path_1.default.resolve(e,i),o=path_1.default.resolve(a,i.replace("-unsigned",""));this.allDestDir.push(a),this.allSrcHapPath.push(l),this.allDestHapPath.push(o)}))}initWithHspModuleData(t,e){const s=t.getModuleTargetOutputFileName("",!1,build_directory_const_js_1.BuildArtifactExtension.DOT_HSP),a=path_1.default.resolve(e,s),i=path_1.default.resolve(e,"app");this.allDestDir.push(i);const l=path_1.default.resolve(i,s.replace("-unsigned",""));this.allSrcHspPath.push(a),this.allDestHspPathList.push(l)}initRemoteHsp(t){if(!fs_extra_1.default.existsSync(t))return;const e=fs_extra_1.default.readdirSync(t);for(const s of e){const e=path_1.default.resolve(t,s),a=(0,remote_hsp_utils_js_1.getRemoteHspObj)(e,s,this._log);a&&(0,remote_hsp_utils_js_1.compareIfSetRemoteHsp)(a,this.allRemoteHspPathMap)&&this.allRemoteHspPathMap.set(a.hspFileName,a)}}checkOutputName(t){const e=new Set;t.forEach((t=>{const s=t.slice(t.lastIndexOf(path_1.default.sep)+1),a=`The customized output name: ${s}, please check the module target configuration in project.`;e.has(s)?this._log._buildError("Failed to build the app due to duplicate customized output names in the current project.")._detail(a)._file(path_1.default.resolve(t))._printErrorAndExit():e.add(s)}))}}exports.PackageApp=PackageApp;