/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
 */

module.exports = {
  'env': {
    'browser': true,
    'node': true
  },
  'extends': [
    'eslint:recommended',
    'plugin:@typescript-eslint/recommended'
  ],
  'parser': '@typescript-eslint/parser',
  'parserOptions': {
    'ecmaVersion': 'latest'
  },
  'plugins': [
    '@typescript-eslint',
    'simple-import-sort'
  ],
  'overrides': [
    // override "simple-import-sort" config
    {
      'files': ['*.ts'],
      'rules': {
        'simple-import-sort/imports': [
          'error',
          {
            'groups': [
              // Packages `react` related packages come first.
              ['^react', '^@?\\w'],

              // Internal packages.
              ['^(@|components)(/.*|$)'],

              // Side effect imports.
              ['^\\u0000'],

              // Parent imports. Put `..` last.
              ['^\\.\\.(?!/?$)', '^\\.\\./?$'],

              // Other relative imports. Put same-folder imports and `.` last.
              ['^\\./(?=.*/)(?!/?$)', '^\\.(?!/?$)', '^\\./?$'],

              // Style imports.
              ['^.+\\.?(css)$']
            ]
          }
        ]
      }
    }
  ],
  'rules': {
    // 总是强制使用===和!==
    'eqeqeq': ['error', 'always'],

    // 规则4 变量名遵循驼峰风格
    'camelcase': ['error', {
      'properties': 'always'
    }],

    // 规则11 注释和上面代码块要有空行，//和注释之间要有一个空格
    'lines-around-comment': ['error', {
      beforeBlockComment: true,
      beforeLineComment: true,
      allowBlockStart: true,
      allowObjectStart: true,
      allowArrayStart: true
    }],
    'spaced-comment': ['error', 'always', {markers: ['/']}],

    // 规则12 正式交付给客户的代码不应包含TODO/FIXME注释
    'no-warning-comments': 'off',

    // 规则15 采用一致的空格缩进
    'indent': ['error', 2, {
      'SwitchCase': 1,
    }],

    // 规则22 每行代码应该少于 120 个字符
    'max-len': ['error', 120],

    // 规则36 使用模板字符串实现字符串拼接
    'prefer-template': 'error',

    // 规则43 禁止在对象实例上直接使用Object.prototype的内部属性
    'no-prototype-builtins': 'error',

    // 规则58 要求调用isNaN()检查NaN
    'use-isnan': 'error',

    // 规则59 禁止在finally语句块中出现控制流语句
    'no-unsafe-finally': 'error',

    // 规则60 禁用不必要的 return await
    'no-return-await': 'error',

    // 规则61 禁止使用with(){}
    'no-with': 'error',

    // 规则62 禁用console
    'no-console': 'warn',

    // 规则63 禁用alert
    'no-alert': 'error',

    // 规则64 禁用debugger
    'no-debugger': 'error',

    // 规则66 禁止多余的 return 语句
    'no-useless-return': 'error',

    // 原则8 禁止使用eval()
    'no-eval': 'error',

    // 原则9 禁止使用隐式的eval()
    'no-implied-eval': 'error',

    // 建议12 不要使用连续空行
    'no-multiple-empty-lines': 'error',

    // 建议16 每句代码后加分号
    'semi': ['warn', 'always'],

    // 建议21 圈复杂度不超过20
    'complexity': ['warn', 20],

    // 建议22 块语句的最大可嵌套深度不要超过4层
    'max-depth': ['warn', 4],

    // 建议36 建议字符串使用单引号
    'quotes': ['error', 'single'],

    // 建议50 不要使用否定表达式
    'no-negated-condition': 'warn',

    // 建议54 禁止正则表达式字面量中出现多个空格
    'no-regex-spaces': 'warn',

    // 建议65 要求使用Error对象作为Promise拒绝的原因
    'prefer-promise-reject-errors': 'warn',

    /* ----------------------禁用规则-----------------------*/

    // 该规则不允许使用!来处理可能为空的值，暂时禁用
    '@typescript-eslint/no-non-null-assertion': 'off',

    // 该规则不允许使用namespace，暂时禁用
    '@typescript-eslint/no-namespace': 'off',

    // 该规则不允许使用require方法为变量赋值，暂时禁用
    '@typescript-eslint/no-var-requires': 'off',

    // 该规则不建议使用Function作为类型声明，暂时禁用
    '@typescript-eslint/ban-types': ['error',
      {
        'types': {
          'Function': false
        }
      }
    ],

    // 建议66 不要使用 continue，该建议在3.0实行规范中已废除，暂时禁用
    'no-continue': 'off',

    // DevEcoCodeCheck20TS新增规则
    'no-unmodified-loop-condition': 'warn',
    'no-shadow-restricted-names': 'error',
    'prefer-object-spread': 'warn',
    'no-iterator': 'warn',
    'array-callback-return': 'warn',
    'no-new-wrappers': 'warn',
    'no-caller': 'warn',
    'no-multi-str': 'error',
    'no-labels': 'warn',
    'no-useless-rename': 'error',
    'grouped-accessor-pairs': 'warn',
    'no-useless-concat': 'error',
    'no-useless-call': 'error',
    'no-new-func': 'error',
    'no-proto': 'error',
    'no-self-compare': 'error',
    '@typescript-eslint/no-dupe-class-members': 'error',
    'no-undef-init': 'error',
    'guard-for-in': 'error',
    'symbol-description': 'error',
    'no-new-object': 'error',
    'prefer-regex-literals': 'error',
    'no-lone-blocks': 'error',
    'no-useless-computed-key': 'error',
    'no-template-curly-in-string': 'warn',
    'no-extend-native': 'error',
    'no-extra-bind': 'warn',
    'no-constructor-return': 'error'
  }
};
