"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isArrayLike_1 = __importDefault(require("./isArrayLike"));
var isArray_1 = __importDefault(require("./isArray"));
function arrayPush(array, values) {
    var index = 0;
    var length = values.length;
    var offset = array.length;
    while (index < length) {
        array[offset + index] = values[index];
        index += 1;
    }
    return array;
}
/**
 * 减少一级array嵌套深度
 *
 * @param input(any) 需要减少嵌套层级的数组
 * @returns array 返回减少嵌套层级后的新数组
 *
 * @example
 * _.flatten([1, [2, [3, [4]], 5]]);
 * // => [1, 2, [3, [4]], 5]
 */
function flatten(input) {
    var e_1, _a;
    if (!(0, isArrayLike_1.default)(input)) {
        return [];
    }
    var result = [];
    if ((0, isArray_1.default)(input)) {
        try {
            for (var input_1 = __values(input), input_1_1 = input_1.next(); !input_1_1.done; input_1_1 = input_1.next()) {
                var item = input_1_1.value;
                if ((0, isArrayLike_1.default)(item)) {
                    arrayPush(result, item);
                }
                else {
                    result.push(item);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (input_1_1 && !input_1_1.done && (_a = input_1.return)) _a.call(input_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return result;
    }
    for (var i = 0; i < input.length; i++) {
        result.push(input["".concat(i)]);
    }
    return result;
}
exports.default = flatten;
