"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var isArrayLike_1 = __importDefault(require("./isArrayLike"));
var isTypedArray_1 = __importDefault(require("./isTypedArray"));
var isPlainObject_1 = require("./isPlainObject");
var validCheck_1 = require("./common/validCheck");
/**
 * 检查是否为Map、Set
 * @param value
 */
function checkIsMapOrSet(value) {
    return (0, isPlainObject_1.getValueTag)(value) === '[object Map]' || (0, isPlainObject_1.getValueTag)(value) === '[object Set]';
}
/**
 * 检查是否为类数组，且其类型为数组、字符串、函数、Buffer对象、类型化数组、参数对象
 * @param value
 */
function checkIsArrayLike(value) {
    if ((0, isArrayLike_1.default)(value)) {
        return Array.isArray(value) || typeof value === 'string' || typeof value.splice === 'function'
            || Buffer.isBuffer(value) || (0, isTypedArray_1.default)(value) || (0, validCheck_1.isArguments)(value);
    }
    return false;
}
/**
 * 检查对象是否为原型对象
 * @param value
 */
function checkIsPrototypeObject(value) {
    var Ctor = value && value.constructor;
    var proto = typeof Ctor === 'function' && Ctor.prototype;
    return value === proto;
}
/**
 * 获取原型对象的keys
 * @param value
 */
function getProtoTypeObjectKeys(value) {
    var result = [];
    Object.keys(value).forEach(function (key) {
        if (Object.prototype.hasOwnProperty.call(value, key) && key !== 'constructor') {
            result.push(key);
        }
    });
    return result;
}
/**
 * 检查 value 是否为一个空对象，集合，映射或者set。
 * 判断的依据是除非是有枚举属性的对象，length 大于 0 的 arguments object, array, string 或类jquery选择器。
 * 对象如果被认为为空，那么他们没有自己的可枚举属性的对象。
 * 类数组值，比如arguments对象，array，buffer，string或者类jQuery集合的length 为 0，被认为是空。
 * 类似的，map（映射）和set 的size 为 0，被认为是空。
 * 如果 value 为空，那么返回 true，否则返回 false。
 * @param value
 */
function isEmpty(value) {
    if (value === null || value === undefined) {
        return true;
    }
    // (1) 如果是Map、Set集合，且集合的size为0
    if (checkIsMapOrSet(value)) {
        return value.size === 0;
    }
    // (2) 如果是类数组且其类型为数组、字符串、函数、Buffer对象、类型化数组、参数对象，其length为0
    if (checkIsArrayLike(value)) {
        return value.length === 0;
    }
    // (3) 如果是原型对象，且原型对象的Keys长度为0；如果是普通对象，则普通对象的key只属于对象自身
    if (checkIsPrototypeObject(value)) {
        return getProtoTypeObjectKeys(value).length === 0;
    }
    else {
        for (var key in value) {
            if (Object.prototype.hasOwnProperty.call(value, key)) {
                return false;
            }
        }
    }
    return true;
}
exports.default = isEmpty;
