import { Stack } from './common/Stack';
export declare const baseMerge: (object: object, source: object, srcIndex: number, customizer?: Function, _stack?: Stack) => void;
/**
 * 该方法类似assign， 除了它递归合并 sources 来源对象自身和继承的可枚举属性到 object 目标对象。
 * 如果目标值存在，被解析为undefined的sources 来源对象属性将被跳过。
 * 数组和普通对象会递归合并，其他对象和值会被直接分配覆盖。源对象从从左到右分配。
 * 后续的来源对象属性会覆盖之前分配的属性。
 *
 * 注意：这方法会改变对象 object.
 *
 * @param {Object} object 目标对象。
 * @param {...Object} [sources] 来源对象。
 * @returns {Object} Returns `object`.
 */
declare const merge: (object: any, ...sources: any[]) => any;
export default merge;
