const { minify } = require('terser');
const glob = require('glob');
const fs = require('fs');

const jsCollection = ['./index.js', ...glob.sync('src/**/*.js', {})];

jsCollection.forEach(jsFile => {
  minify({
    jsFile: fs.readFileSync(jsFile, 'utf8')
  }).then( value => {
    fs.writeFile(jsFile, value.code, 'utf8', (err) => {
      if (err) throw err;
    });
  });
});
