"use strict";var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,r,s){void 0===s&&(s=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,s,a)}:function(e,t,r,s){void 0===s&&(s=r),e[s]=t[r]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&__createBinding(t,e,r);return __setModuleDefault(t,e),t},__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.SessionIdHelper=void 0;const buffer_1=__importDefault(require("buffer")),crypto_1=__importStar(require("crypto")),fs_1=__importDefault(require("fs")),fs_extra_1=__importDefault(require("fs-extra")),path_1=__importDefault(require("path")),global_data_js_1=require("../../internal/data/global-data.js"),hvigor_log_js_1=require("../../log/hvigor-log.js"),daemon_const_js_1=require("../const/daemon-const.js"),log=hvigor_log_js_1.HvigorLogger.getLogger("SessionIdHelper");class SessionIdHelper{static encryptPwdByDefaultMaterial(e,t){return SessionIdHelper.encryptPwd(e,t)}static encryptPwd(e,t){let r=buffer_1.default.Buffer.from("");try{const t=new Int8Array(buffer_1.default.Buffer.from(e));r=SessionIdHelper.encrypt(SessionIdHelper.key,t)}catch(e){t.errorMessageExit("Encrypt failed"),global_data_js_1.startParameters.printStackTrace&&e.stack&&t.errorMessageExit(e.stack)}return r.toString("hex")}static encrypt(e,t){const r=new Int8Array((0,crypto_1.randomBytes)(12)),s=crypto_1.default.createCipheriv("aes-128-gcm",e,r),a=s.update(t),n=s.final(),o=new Int8Array(s.getAuthTag()),i=new Int8Array(buffer_1.default.Buffer.concat([a,n])),_=i.length+o.length,d=new Int8Array(4+r.length+i.length+o.length);d[0]=_>>24&255,d[1]=_>>16&255,d[2]=_>>8&255,d[3]=255&_;for(let e=0;e<r.length;e++)d[e+4]=r[e];for(let e=0;e<i.length;e++)d[e+16]=i[e];const l=4+r.length+i.length;for(let e=0;e<o.length;e++)d[e+l]=o[e];return buffer_1.default.Buffer.from(d)}static decryptPwdByDefaultMaterial(e,t){return SessionIdHelper.decryptPwd(e,t)}static decryptPwd(e,t){let r=buffer_1.default.Buffer.from("");try{const t=new Int8Array(buffer_1.default.Buffer.from(e,"hex"));r=SessionIdHelper.decrypt(SessionIdHelper.key,t)}catch(e){t.errorMessageExit("Decryption failed"),global_data_js_1.startParameters.printStackTrace&&e.stack&&t.errorMessageExit(e.stack)}return r.toString("utf-8")}static decrypt(e,t){const r=(255&t[0])<<24|(255&t[1])<<16|(255&t[2])<<8|255&t[3],s=t.length-4-r,a=t.slice(4,4+s),n=crypto_1.default.createDecipheriv("aes-128-gcm",e,a),o=t.slice(t.length-16);n.setAuthTag(o);const i=n.update(t.subarray(4+s,t.length-16)),_=n.final();return buffer_1.default.Buffer.concat([i,_])}static getKey(e,t){fs_1.default.existsSync(daemon_const_js_1.DEFAULT_DAEMON_META_PATH)||SessionIdHelper.createMaterial(t),fs_1.default.statSync(daemon_const_js_1.DEFAULT_DAEMON_META_PATH).isDirectory()||t.errorMessageExit("No materials.");const r=fs_1.default.readdirSync(daemon_const_js_1.DEFAULT_DAEMON_META_PATH);0===r.length&&t.errorMessageExit("No materials."),this.dirs.forEach((e=>{r.includes(e)||t.errorMessageExit(`Can not find signing material ${e}`)}));const s=SessionIdHelper.readFd(path_1.default.resolve(daemon_const_js_1.DEFAULT_DAEMON_META_PATH,this.dirs[0]),t),a=SessionIdHelper.readSalt(path_1.default.resolve(daemon_const_js_1.DEFAULT_DAEMON_META_PATH,this.dirs[1]),t),n=SessionIdHelper.getRootKey(s,a,t),o=SessionIdHelper.readWorkMaterial(path_1.default.resolve(daemon_const_js_1.DEFAULT_DAEMON_META_PATH,this.dirs[2]),t);return new Int8Array(SessionIdHelper.decrypt(n,o))}static getRootKey(e,t,r){const s=e.concat(SessionIdHelper.component),a=SessionIdHelper.xorComponents(s,r),n=crypto_1.default.pbkdf2Sync(a.toString(),t,1e4,16,"sha256");return new Int8Array(n)}static xorComponents(e,t){e.forEach((e=>{16!==e.length&&t.errorMessageExit("Signing material data error!")}));let r=SessionIdHelper.xor(e[0],e[1],t);for(let s=2;s<e.length;s++)r=SessionIdHelper.xor(r,e[s],t);return buffer_1.default.Buffer.from(r)}static xor(e,t,r){e.byteLength!==t.byteLength&&r.errorMessageExit("Signing material data error!");const s=new Int8Array(e.byteLength);for(let r=0;r<e.byteLength;r++)s[r]=e[r]^t[r];return s}static readFd(e,t){fs_1.default.existsSync(e)||t.errorMessageExit("Material not found!");const r=fs_1.default.readdirSync(e).filter((e=>e!=SessionIdHelper.macDSStore));3!==r.length&&t.errorMessageExit("Signing material is illegal!");const s=[];return r.forEach((r=>s.push(SessionIdHelper.readDirBytes(path_1.default.resolve(e,r),t)))),s}static readSalt(e,t){return SessionIdHelper.readDirBytes(e,t)}static readWorkMaterial(e,t){return SessionIdHelper.readDirBytes(e,t)}static readDirBytes(e,t){fs_1.default.existsSync(e)&&fs_1.default.statSync(e).isDirectory()||t.errorMessageExit(`Can not find the signing material: ${e}`);const r=fs_1.default.readdirSync(e).filter((e=>e!=SessionIdHelper.macDSStore));1!==r.length&&t.errorMessageExit("Signing material error");const s=fs_1.default.readFileSync(path_1.default.resolve(e,r[0]));return new Int8Array(s)}static createMaterial(e){e.debug("begin to create new key files");const t=path_1.default.join(daemon_const_js_1.DEFAULT_DAEMON_META_PATH);fs_extra_1.default.existsSync(t)||fs_extra_1.default.mkdirsSync(t),fs_1.default.chmodSync(path_1.default.join(t),daemon_const_js_1.KEY_FILE_DIRECTORY_PERMISSIONS);const r=path_1.default.join(t,this.dirs[0]),s=SessionIdHelper.createAndStoreKey(path_1.default.join(r,"0"),daemon_const_js_1.DAEMON_ROOT_KEY_COMPONENT_LENGTH),a=SessionIdHelper.createAndStoreKey(path_1.default.join(r,"1"),daemon_const_js_1.DAEMON_ROOT_KEY_COMPONENT_LENGTH),n=SessionIdHelper.createAndStoreKey(path_1.default.join(r,"2"),daemon_const_js_1.DAEMON_ROOT_KEY_COMPONENT_LENGTH),o=SessionIdHelper.createAndStoreKey(path_1.default.join(t,this.dirs[1]),daemon_const_js_1.DAEMON_SALT_KEY_LENGTH),i=SessionIdHelper.getRootKey([s,a,n],o,e);SessionIdHelper.createAndStoreEnKey(i,path_1.default.join(t,this.dirs[2]))}static createAndStoreKey(e,t){const r=new Int8Array((0,crypto_1.randomBytes)(16)),s=(0,crypto_1.createHash)("sha256").update(r).digest("hex");fs_extra_1.default.existsSync(e)||fs_extra_1.default.mkdirpSync(e);const a=path_1.default.join(e,s);return fs_1.default.writeFileSync(a,r),fs_extra_1.default.chmodSync(a,daemon_const_js_1.KEY_FILE_PERMISSIONS),r}static createAndStoreEnKey(e,t){const r=new Int8Array((0,crypto_1.randomBytes)(daemon_const_js_1.DAEMON_WORK_KEY_LENGTH)),s=SessionIdHelper.encrypt(e,r),a=(0,crypto_1.createHash)("sha256").update(s).digest("hex");fs_extra_1.default.existsSync(t)||fs_extra_1.default.mkdirpSync(t);const n=path_1.default.join(t,a);fs_1.default.writeFileSync(n,s),fs_1.default.chmodSync(n,daemon_const_js_1.KEY_FILE_PERMISSIONS)}}exports.SessionIdHelper=SessionIdHelper,SessionIdHelper.dirs=["fd","ac","ce"],SessionIdHelper.macDSStore=".DS_Store",SessionIdHelper.component=new Int8Array([49,243,9,115,214,175,91,184,211,190,177,88,101,131,192,119]),SessionIdHelper.key=SessionIdHelper.getKey(daemon_const_js_1.DEFAULT_DAEMON_META_PATH,log);