"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.normalWorker=exports.watchWorker=void 0;const cluster_1=__importDefault(require("cluster")),worker_threads_1=require("worker_threads"),noop_js_1=require("../../../../common/util/noop.js"),build_event_js_1=require("../../../common/daemon-protocol/build-event.js"),hvigor_log_js_1=require("../../../log/hvigor-log.js"),duration_event_js_1=require("../../../metrics/event/duration-event.js"),log_event_js_1=require("../../../metrics/event/log-event.js"),constant_js_1=require("../constant/constant.js"),log=hvigor_log_js_1.HvigorLogger.getLogger("daemon");class WorkerItem{constructor(e,t){this.worker=e,this.hasCustomTerminate=t}}const genPromiseAndTriggers=()=>{let e=noop_js_1.noop,t=noop_js_1.noop;const r=new Promise(((r,o)=>{e=o,t=r}));return{reject:e,resolve:t,promise:r}};async function handleResponse(e,t,r,o,n,s){if(e.event!==constant_js_1.PoolConstant.WORK_DONE){if(e.event===constant_js_1.PoolConstant.WORK_ERROR){null==s||s.stop(duration_event_js_1.DurationEventState.FAILED),null==s||s.setLog(null==s?void 0:s.getName(),log_event_js_1.MetricLogType.ERROR),await n(e.returnVal);const a=e.error,i=`${t.getName()} ${o?"watch":"normal"} work[${r}] failed.`;throw log.debug(i),new Error(a||i)}throw new Error(`Unknown worker event: ${e}.`)}null==s||s.stop(duration_event_js_1.DurationEventState.SUCCESS),null==s||s.setLog(null==s?void 0:s.getName(),log_event_js_1.MetricLogType.INFO),await n(e.returnVal)}class WatchWorker{constructor(){this.workerMap=new Map,this.cnt=0,this.addListenersOnSessionManager()}getWorker(e){var t;return null===(t=this.workerMap.get(e))||void 0===t?void 0:t.worker}createWorker(e,t,r,o,n){const s=new worker_threads_1.Worker(t,n),a=++this.cnt;this.workerMap.set(a,new WorkerItem(s,r));const i=e.addSubDurationEvent(a.toString()).start();null==i||i.setTid(`Worker${a}`),cluster_1.default.isWorker&&process.send({type:build_event_js_1.WatchEvent.NEW_WATCH_WORKER,workerId:a});const{promise:_,resolve:l,reject:d}=genPromiseAndTriggers();return e.pendingPromises.add(_),s.on("message",(async t=>{if(t){if(!t.event)return t.type===build_event_js_1.WatchEvent.WATCH_COMPILE_RESULT||t.type===build_event_js_1.WatchEvent.WATCH_START||t.type===build_event_js_1.WatchEvent.WATCH_RESULT||t.type===build_event_js_1.WatchEvent.WATCH_LOG?(log.debug(`watch worker: send response to session manager. Response type: ${t.type}`),void(cluster_1.default.isWorker&&process.send({...t,workerId:a}))):t.type===build_event_js_1.WatchEvent.TERMINATE_WORKER?(log.debug("watch worker: worker is ready to be terminated."),void this.terminateWorker(t.content)):void d(new Error(`Unknown watch event: ${t}.`));try{await handleResponse(t,e,a,!0,o,i),l("succeed")}catch(e){d(e)}}else d(new Error("Undefined response."))})),s.on("error",(async t=>{log.error(`${e.getName()} watch work[${a}] failed.`),log.error(t),d(t)})),a.toString()}beforeTerminate(e){var t,r;(null===(t=this.workerMap.get(e))||void 0===t?void 0:t.hasCustomTerminate)?null===(r=this.workerMap.get(e))||void 0===r||r.worker.postMessage({type:build_event_js_1.WatchEvent.TERMINATE_WORKER,content:e}):this.terminateWorker(e)}terminateWorker(e){var t;null===(t=this.workerMap.get(e))||void 0===t||t.worker.terminate(),this.workerMap.delete(e),log.debug(`Server currently has ${this.workerMap.size} `+(this.workerMap.size>1?"watch-workers":"watch-worker"))}addListenersOnSessionManager(){cluster_1.default.isWorker&&cluster_1.default.worker.on("message",(e=>{var t;void 0!==e.workerId&&0!==e.workerId?e.type===build_event_js_1.WatchEvent.WATCH_COMPILE_DATA?(log.debug("watch worker: receive watch compile tata."),null===(t=this.getWorker(e.workerId))||void 0===t||t.postMessage(e.content)):e.type===build_event_js_1.WatchEvent.CLOSE_WATCH&&this.beforeTerminate(e.workerId):log.debug("watch worker: worker id should be larger than 0. Nothing will be sent to any worker thread.")}))}}class NormalWorker{constructor(){this.cnt=0}createWorker(e,t,r,o,n){const s=new worker_threads_1.Worker(t,n),a=++this.cnt,i=e.addSubDurationEvent(a.toString()).start();null==i||i.setTid(`Worker${a}`);const{promise:_,resolve:l,reject:d}=genPromiseAndTriggers();return e.pendingPromises.add(_),s.on("message",(async t=>{if(t)if(t.event)try{await handleResponse(t,e,a,!1,o,i),t.event!==constant_js_1.PoolConstant.WORK_DONE&&t.event!==constant_js_1.PoolConstant.WORK_ERROR||s.terminate(),l(!0)}catch(e){d(e)}else t.type!==build_event_js_1.WatchEvent.WATCH_COMPILE_RESULT&&t.type!==build_event_js_1.WatchEvent.WATCH_START&&t.type!==build_event_js_1.WatchEvent.WATCH_RESULT&&t.type!==build_event_js_1.WatchEvent.WATCH_LOG&&(t.type!==build_event_js_1.WatchEvent.TERMINATE_WORKER?d(new Error(`Unknown watch event: ${t}.`)):s.terminate());else d(new Error("Undefined response."))})),s.on("error",(async t=>{log.debug(`${e.getName()} normal work[${a}] failed.`),d(t)})),a.toString()}}exports.watchWorker=new WatchWorker,exports.normalWorker=new NormalWorker;