"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetCache = void 0;
var MapCache_1 = __importDefault(require("./MapCache"));
var HASH_UNDEFINED = '__wdk_hash_undefined__';
var SetCache = /** @class */ (function () {
    function SetCache(values) {
        this.wdkData = new MapCache_1.default(undefined);
        var index = -1;
        var length = values == null ? 0 : values.length;
        while (++index < length) {
            this.add(values[index]);
        }
    }
    SetCache.prototype.add = function (value) {
        this.wdkData.set(value, HASH_UNDEFINED);
        return this;
    };
    SetCache.prototype.has = function (value) {
        return this.wdkData.has(value);
    };
    SetCache.prototype.push = function (value) {
        this.add(value);
    };
    return SetCache;
}());
exports.SetCache = SetCache;
