"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ObjType = exports.getType = void 0;
/**
 * 获取元素类型
 * @param o
 * @returns
 */
function getType(target) {
    return Object.prototype.toString.call(target);
}
exports.getType = getType;
var ObjType;
(function (ObjType) {
    ObjType["Arguments"] = "[object Arguments]";
    ObjType["Array"] = "[object Array]";
    ObjType["AsyncFunction"] = "[object AsyncFunction]";
    ObjType["Boolean"] = "[object Boolean]";
    ObjType["Date"] = "[object Date]";
    ObjType["DOMException"] = "[object DOMException]";
    ObjType["Error"] = "[object Error]";
    ObjType["Function"] = "[object Function]";
    ObjType["GeneratorFunction"] = "[object GeneratorFunction]";
    ObjType["Map"] = "[object Map]";
    ObjType["Number"] = "[object Number]";
    ObjType["Null"] = "[object Null]";
    ObjType["Object"] = "[object Object]";
    ObjType["Promise"] = "[object Promise]";
    ObjType["Proxy"] = "[object Proxy]";
    ObjType["RegExp"] = "[object RegExp]";
    ObjType["Set"] = "[object Set]";
    ObjType["String"] = "[object String]";
    ObjType["Symbol"] = "[object Symbol]";
    ObjType["Undefined"] = "[object Undefined]";
    ObjType["WeakMap"] = "[object WeakMap]";
    ObjType["WeakSet"] = "[object WeakSet]";
    ObjType["ArrayBuffer"] = "[object ArrayBuffer]";
    ObjType["DataView"] = "[object DataView]";
    ObjType["Float32Array"] = "[object Float32Array]";
    ObjType["Float64Array"] = "[object Float64Array]";
    ObjType["Int8Array"] = "[object Int8Array]";
    ObjType["Int16Array"] = "[object Int16Array]";
    ObjType["Int32Array"] = "[object Int32Array]";
    ObjType["Uint8Array"] = "[object Uint8Array]";
    ObjType["Uint8ClampedArray"] = "[object Uint8ClampedArray]";
    ObjType["Uint16Array"] = "[object Uint16Array]";
    ObjType["Uint32Array"] = "[object Uint32Array]";
})(ObjType = exports.ObjType || (exports.ObjType = {}));
