"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var baseDiffrence_1 = require("./common/baseDiffrence");
var baseFlatten_1 = require("./common/baseFlatten");
var isArrayLikeObject_1 = __importDefault(require("./isArrayLikeObject"));
/**
 * 从array中取出经comparator函数比较在其他数组values中不存在的所有元素，并返回这些元素组成的新数组
 * @param array，原数组
 * @param valuesAndComparator，其他所有数组values以及comparator
 * @return 原数组array中在其他数组中不存在的元素组成的新数组
 */
function differenceWith(array) {
    var valuesAndComparator = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        valuesAndComparator[_i - 1] = arguments[_i];
    }
    var comparator;
    var values = valuesAndComparator;
    var length = valuesAndComparator.length;
    var lastEle = valuesAndComparator[length - 1];
    if (typeof lastEle === 'function') {
        comparator = lastEle;
        values = valuesAndComparator.slice(0, length - 1);
    }
    return (0, baseDiffrence_1.baseDifference)(array, (0, baseFlatten_1.baseFlatten)(values, 1, isArrayLikeObject_1.default, true, undefined), undefined, comparator);
}
exports.default = differenceWith;
