"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getValueTag = void 0;
var symToStringTag = Symbol.toStringTag;
// 当对象的属性为Symbol类型时，需要转换其具体类型
var getSymbolTag = function (value) {
    var isOwn = Object.prototype.hasOwnProperty.call(value, symToStringTag);
    var tag = value[symToStringTag];
    var unmasked = false;
    try {
        value[symToStringTag] = undefined;
        unmasked = true;
    }
    catch (e) {
    }
    var result = Object.prototype.toString.call(value);
    if (unmasked) {
        if (isOwn) {
            value[symToStringTag] = tag;
        }
        else {
            delete value[symToStringTag];
        }
    }
    return result;
};
var getValueTag = function (value) {
    if (symToStringTag && symToStringTag in Object(value)) {
        return getSymbolTag(value);
    }
    return Object.prototype.toString.call(value);
};
exports.getValueTag = getValueTag;
/**
 * 检查 value 是否是普通对象。 也就是说该对象由 Object构造函数创建，或者 [[Prototype]] 为 null
 * 即，通过 {}、new Object()、Object.create(null) 创建的对象，且该对象的prototype为null，就是普通对象
 * 如果 value 为一个普通对象，那么返回 true，否则返回 false
 * @param value 要检查的值
 */
function isPlainObject(value) {
    if (typeof value !== 'object' || value === null || value === undefined || (0, exports.getValueTag)(value) !== '[object Object]') {
        return false;
    }
    // 通过value的__proto__跟value次顶层的__proto__做对比，如果相等则返回true
    var topProto = Object.getPrototypeOf(value);
    while (topProto && Object.getPrototypeOf(topProto) !== null) {
        topProto = Object.getPrototypeOf(topProto);
    }
    return Object.getPrototypeOf(value) === topProto;
}
exports.default = isPlainObject;
