"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var arrayLikeKeys_1 = __importDefault(require("./common/arrayLikeKeys"));
var validCheck_1 = require("./common/validCheck");
var isArrayLike_1 = __importDefault(require("./isArrayLike"));
var isObject_1 = __importDefault(require("./isObject"));
function nativeKeysIn(object) {
    var result = [];
    if (object === null || object === undefined) {
        return result;
    }
    var toObj = Object(object);
    for (var key in toObj) {
        if (key in toObj) {
            result.push(key);
        }
    }
    return result;
}
function baseKeysIn(object) {
    if (!(0, isObject_1.default)(object)) {
        return nativeKeysIn(object);
    }
    var isProto = (0, validCheck_1.isPrototype)(object);
    var result = [];
    for (var key in object) {
        if (!(key === 'constructor' && (isProto || !Object.prototype.hasOwnProperty.call(object, key)))) {
            result.push(key);
        }
    }
    return result;
}
/**
 * 创建一个 object 自身 和 继承的可枚举属性名为数组。
 * 注意: 非对象的值会被强制转换为对象。
 *
 * @param object 要检索的对象
 * @returns string[] 返回包含属性名的数组。。
 */
function keysIn(object) {
    return (0, isArrayLike_1.default)(object) ? (0, arrayLikeKeys_1.default)(object, true) : baseKeysIn(object);
}
exports.default = keysIn;
