import premierlibrary from 'libpremierlibrary.so';
import { ObjCreateHelper } from '../utils/ObjCreateHelper';
import { ErrorInfo } from '../player/bean/ErrorInfo';
import { findErrorCodeByValue, PlayerErrorCode } from '../player/bean/PlayerErrorCode';
import { AliPlayerGlobalSettings } from '../player/AliPlayerGlobalSettings';
export class VodMediaLoader {
    constructor() {
        this.objHelper = new ObjCreateHelper();
        this.onPrepared = (y6) => {
            if (this.mOnLoadStatusListener) {
                this.mOnLoadStatusListener.onPrepared(y6);
            }
        };
        this.onError = (u6, v6, w6, x6) => {
            console.log('VodMedialoader onError called, url: ' + u6 + " index " + v6 + " code: " + w6 + " msg " + x6);
            if (this.mOnLoadStatusListener) {
                this.mOnLoadStatusListener.onError(u6, v6, w6, x6);
            }
            if (w6 != PlayerErrorCode.MEDIALOADER_ERROR_ADDED) {
                VodMediaLoader.getInstance().cancel(u6, v6);
            }
        };
        this.onErrorV2 = (o6, p6, q6, r6) => {
            console.log('VodMedialoader onErrorV2 called, url: ' + o6 + " index " + p6 + " code: " + q6 + " msg " + r6);
            if (this.mOnLoadStatusListener != null) {
                let s6 = findErrorCodeByValue(q6);
                let t6 = new ErrorInfo();
                t6.setCode(s6);
                t6.setMsg(r6);
                this.mOnLoadStatusListener.onErrorV2(o6, p6, t6);
            }
            if (q6 != PlayerErrorCode.MEDIALOADER_ERROR_ADDED) {
                VodMediaLoader.getInstance().cancel(o6, p6);
            }
        };
        this.onCompleted = (m6, n6) => {
            if (this.mOnLoadStatusListener) {
                this.mOnLoadStatusListener.onCompleted(m6, n6);
            }
        };
        this.onCanceled = (k6, l6) => {
            if (this.mOnLoadStatusListener) {
                this.mOnLoadStatusListener.onCanceled(k6, l6);
            }
        };
        premierlibrary.nVodMediaLoaderConstruct(this);
    }
    static getInstance() {
        if (!VodMediaLoader.sInstance) {
            VodMediaLoader.sInstance = new VodMediaLoader();
        }
        return VodMediaLoader.sInstance;
    }
    prepareVidStsSource(e6) {
        premierlibrary.nVodMediaLoaderPrepareSts(e6);
    }
    prepareVidAuthSource(d6) {
        premierlibrary.nVodMediaLoaderPrepareAuth(d6);
    }
    removeVidSource(c6) {
        premierlibrary.nVodMediaLoaderRemoveSource(c6);
    }
    load(x5, y5, z5) {
        if (!x5 || y5 < 0) {
            return;
        }
        let a6 = premierlibrary.nVodMediaLoaderGetVodUrl(x5, y5);
        let b6 = AliPlayerGlobalSettings.OnGetUrlHashCallback(a6);
        premierlibrary.nVodMediaLoaderLoad(x5, y5, b6, z5);
    }
    cancel(t5, u5) {
        let v5 = premierlibrary.nVodMediaLoaderGetVodUrl(t5, u5);
        let w5 = AliPlayerGlobalSettings.OnGetUrlHashCallback(v5);
        premierlibrary.nVodMediaLoaderCancel(t5, u5, w5);
    }
    pause(p5, q5) {
        if (!p5 || q5 < 0) {
            return;
        }
        let r5 = premierlibrary.nVodMediaLoaderGetVodUrl(p5, q5);
        let s5 = AliPlayerGlobalSettings.OnGetUrlHashCallback(r5);
        premierlibrary.nVodMediaLoaderPause(true, p5, q5, s5);
    }
    resume(l5, m5) {
        if (!l5 || m5 < 0) {
            return;
        }
        let n5 = premierlibrary.nVodMediaLoaderGetVodUrl(l5, m5);
        let o5 = AliPlayerGlobalSettings.OnGetUrlHashCallback(n5);
        premierlibrary.nVodMediaLoaderPause(false, l5, m5, o5);
    }
    setOnLoadStatusListener(k5) {
        this.mOnLoadStatusListener = k5;
    }
}
