import { Log } from '../utils/Log';
const log = new Log('AVPBase');
const preparedListenerMap = new WeakMap();
const onInfoListenerMap = new WeakMap();
const onRenderingStartListenerMap = new WeakMap();
const onStateChangedListenerMap = new WeakMap();
const onCompletionListenerMap = new WeakMap();
const onLoadingStatusListenerMap = new WeakMap();
const onErrorListenerMap = new WeakMap();
const onVideoSizeChangedListenerMap = new WeakMap();
const onSeekCompleteListenerMap = new WeakMap();
const onSubtitleDisplayListenerMap = new WeakMap();
const onVideoRenderedListenerMap = new WeakMap();
const onAudioInterruptEventListenerMap = new WeakMap();
const onTrackReadyListenerMap = new WeakMap();
const onSubTrackReadyListenerMap = new WeakMap();
const onSwichStreamListenerMap = new WeakMap();
const onAVNotSyncStatusListenerMap = new WeakMap();
const onTrackChangedListenerMap = new WeakMap();
const onSnapShotListenerMap = new WeakMap();
const onSeiDataListenerMap = new WeakMap();
export class AVPBase {
    constructor(i17, j17) {
        this.mOutMediaInfo = null;
        this.mOutSubMediaInfo = null;
        this.mOutOnPreparedListener = null;
        this.mInnerOnPreparedListener = new InnerPrepareListener(this);
        this.mOutOnInfoListener = null;
        this.mInnerOnInfoListener = new InnerInfoListener(this);
        this.mOutOnRenderingStartListener = null;
        this.mInnerOnRenderingStartListener = new InnerRenderingStartListener(this);
        this.mOutOnStateChangedListener = null;
        this.mInnerOnStateChangedListener = new InnerStateChangedListener(this);
        this.mOutOnVideoSizeChangedListener = null;
        this.mInnerOnVideoSizeChangedListener = new InnerVideoSizeChangedListener(this);
        this.mOutOnLoadingStatusListener = null;
        this.mInnerOnLoadingStatusListener = new InnerLoadingStatusListener(this);
        this.mOutOnSeekCompleteListener = null;
        this.mInnerOnSeekCompleteListener = new InnerSeekCompleteListener(this);
        this.mOutOnCompletionListener = null;
        this.mInnerOnCompletionListener = new InnerCompletionListener(this);
        this.mOutOnVideoRenderedListener = null;
        this.mInnerOnVideoRenderedListener = new InnerVideoRenderedListener(this);
        this.mOutOnSubtitleDisplayListener = null;
        this.mInnerOnSubtitleDisplayListener = new InnerSubtitleDisplayListener(this);
        this.mOutOnErrorListener = null;
        this.mInnerOnErrorListener = new InnerErrorListener(this);
        this.mOutOnAudioInterruptEventListener = null;
        this.mInnerOnAudioInterruptEventListener = new InnerAudioInterruptEventListener(this);
        this.mOutOnTrackReadyListener = null;
        this.mInnerOnTrackReadyListener = new InnerTrackReadyListener(this);
        this.mOutOnSubTrackReadyListener = null;
        this.mInnerOnSubTrackReadyListener = new InnerSubTrackReadyListener(this);
        this.mOutOnStreamSwitchedListener = null;
        this.mInnerOnStreamSwitchedListener = new InnerStreamSwitchedListener(this);
        this.mOutOnAVNotSyncStatusListener = null;
        this.mInnerOnAVNotSyncStatusListener = new InnerOnAVNotSyncStatusListener(this);
        this.mOutOnTrackChangedListener = null;
        this.mInnerOnTrackChangedListener = new InnerTrackChangedListener(this);
        this.mOutOnSnapShotListener = null;
        this.mInnerOnSnapShotListener = new InnerSnapShotListener(this);
        this.mOutOnSeiDataListener = null;
        this.mInnerOnSeiDataListener = new InnerSeiDataListener(this);
        this.mContext = i17;
        this.mTraceId = j17;
        this.mCorePlayer = this.createAlivcMediaPlayer(i17);
        this.mCorePlayer.setTraceId(this.mTraceId);
        preparedListenerMap.set(this, this.mInnerOnPreparedListener);
        onInfoListenerMap.set(this, this.mInnerOnInfoListener);
        onRenderingStartListenerMap.set(this, this.mInnerOnRenderingStartListener);
        onStateChangedListenerMap.set(this, this.mInnerOnStateChangedListener);
        onCompletionListenerMap.set(this, this.mInnerOnCompletionListener);
        onLoadingStatusListenerMap.set(this, this.mInnerOnLoadingStatusListener);
        onErrorListenerMap.set(this, this.mInnerOnErrorListener);
        onVideoSizeChangedListenerMap.set(this, this.mInnerOnVideoSizeChangedListener);
        onSeekCompleteListenerMap.set(this, this.mInnerOnSeekCompleteListener);
        onSubtitleDisplayListenerMap.set(this, this.mInnerOnSubtitleDisplayListener);
        onVideoRenderedListenerMap.set(this, this.mInnerOnVideoRenderedListener);
        onAudioInterruptEventListenerMap.set(this, this.mInnerOnAudioInterruptEventListener);
        onTrackReadyListenerMap.set(this, this.mInnerOnTrackReadyListener);
        onSubTrackReadyListenerMap.set(this, this.mInnerOnSubTrackReadyListener);
        onSwichStreamListenerMap.set(this, this.mInnerOnStreamSwitchedListener);
        onAVNotSyncStatusListenerMap.set(this, this.mInnerOnAVNotSyncStatusListener);
        onTrackChangedListenerMap.set(this, this.mInnerOnTrackChangedListener);
        onSnapShotListenerMap.set(this, this.mInnerOnSnapShotListener);
        onSeiDataListenerMap.set(this, this.mInnerOnSeiDataListener);
        this.bindListener();
    }
    getNativeContextAddr() {
        return this.mCorePlayer?.getNativeContextAddr();
    }
    prepare() {
        this.prepareInner();
    }
    prepareInner() {
        this.mCorePlayer?.prepare();
    }
    getCorePlayer() {
        return this.mCorePlayer;
    }
    start() {
        this.startInner();
    }
    startInner() {
        this.mCorePlayer?.start();
    }
    pause() {
        this.pauseInner();
    }
    pauseInner() {
        this.mCorePlayer?.pause();
    }
    stop() {
        let h17 = "protected.playEvent.user.stop";
        this.setGlobalTime(h17);
        this.stopInner();
    }
    stopInner() {
        this.mCorePlayer?.stop();
    }
    setAutoPlay(g17) {
        this.mCorePlayer?.setAutoPlay(g17);
    }
    setSurfaceId(f17) {
        this.mCorePlayer?.setSurfaceId(f17);
    }
    setSpeed(e17) {
        this.mCorePlayer?.setSpeed(e17);
    }
    setVolume(d17) {
        this.mCorePlayer?.setVolume(d17);
    }
    getVolume() {
        return this.mCorePlayer?.getVolume();
    }
    seekTo(b17, c17) {
        this.mCorePlayer?.seekTo(b17, c17);
    }
    setStartTime(z16, a17) {
        this.mCorePlayer?.setStartTime(z16, a17);
    }
    getDuration() {
        return this.mCorePlayer?.getDuration();
    }
    getPlayedDuration() {
        return this.mCorePlayer?.getPlayedDuration();
    }
    getCurrentPosition() {
        return this.mCorePlayer?.getCurrentPosition();
    }
    getBufferedPosition() {
        return this.mCorePlayer?.getBufferedPosition();
    }
    getPlayerStatus() {
        return this.mCorePlayer?.getPlayerStatus();
    }
    enableHardwareDecoder(y16) {
        this.mCorePlayer?.enableHardwareDecoder(y16);
    }
    release() {
        let x16 = "protected.playEvent.user.destroy";
        this.setGlobalTime(x16);
        this.releaseInner();
    }
    setGlobalTime(w16) {
        this.mCorePlayer?.setGlobalTime(w16);
    }
    releaseInner() {
        this.mCorePlayer?.release();
    }
    releaseAsync() {
        let u16 = "protected.playEvent.user.destroy";
        this.setGlobalTime(u16);
        log.info('releaseAsync');
        this.pause();
        setTimeout(() => {
            this.stopInner();
            this.releaseInner();
        }, 0);
    }
    setMute(t16) {
        this.mCorePlayer?.setMute(t16);
    }
    isMuted() {
        return this.mCorePlayer?.isMuted();
    }
    setScaleMode(s16) {
        this.mCorePlayer?.setScaleMode(s16);
    }
    getScaleMode() {
        return this.mCorePlayer?.getScaleMode();
    }
    setLoop(r16) {
        this.mCorePlayer?.setLoop(r16);
    }
    isLoop() {
        return this.mCorePlayer?.isLoop();
    }
    getVideoWidth() {
        return this.mCorePlayer?.getVideoWidth();
    }
    getVideoHeight() {
        return this.mCorePlayer?.getVideoHeight();
    }
    getVideoRotation() {
        return this.mCorePlayer?.getVideoRotation();
    }
    reload() {
        this.mCorePlayer?.reload();
    }
    setRotateMode(q16) {
        this.mCorePlayer?.setRotateMode(q16);
    }
    getRotateMode() {
        return this.mCorePlayer?.getRotateMode();
    }
    setMirrorMode(p16) {
        this.mCorePlayer?.setMirrorMode(p16);
    }
    getMirrorMode() {
        return this.mCorePlayer?.getMirrorMode();
    }
    setAlphaRenderMode(o16) {
        this.mCorePlayer?.setAlphaRenderMode(o16);
    }
    getAlphaRenderMode() {
        return this.mCorePlayer?.getAlphaRenderMode();
    }
    setVideoBackgroundColor(n16) {
        this.mCorePlayer?.setVideoBackgroundColor(n16);
    }
    getSpeed() {
        return this.mCorePlayer?.getSpeed();
    }
    isAutoPlay() {
        return this.mCorePlayer?.isAutoPlay();
    }
    setConfig(m16) {
        this.mCorePlayer?.setConfig(m16);
    }
    getConfig() {
        return this.mCorePlayer?.getConfig();
    }
    setPlayerScene(l16) {
        this.mCorePlayer?.setPlayerScene(l16);
    }
    setOption(i16, j16) {
        let k16 = "player_option_" + i16 + "_str";
        this.mCorePlayer?.setOption(k16, j16);
    }
    setOptionNum(f16, g16) {
        let h16 = "player_option_" + f16.toString() + "_str";
        this.mCorePlayer?.setOption(h16, g16.toString());
    }
    getOption(e16) {
        return this.mCorePlayer?.getOption(e16);
    }
    selectTrack(d16) {
        this.mCorePlayer?.selectTrack(d16);
    }
    switchStream(c16) {
        this.mCorePlayer?.switchStream(c16);
    }
    getMediaInfo() {
        return this.mOutMediaInfo;
    }
    getSubMediaInfo() {
        return this.mOutSubMediaInfo;
    }
    currentTrack(b16) {
        if (this.mCorePlayer) {
            return this.mCorePlayer.getCurrentTrack(b16);
        }
        else {
            return null;
        }
    }
    addExtSubtitle(a16) {
        this.mCorePlayer?.addExtSubtitle(a16);
    }
    ;
    selectExtSubtitle(y15, z15) {
        this.mCorePlayer?.selectExtSubtitle(y15, z15);
    }
    setStreamDelay(w15, x15) {
        this.mCorePlayer?.setStreamDelay(w15, x15);
    }
    setMaxAccurateSeekDelta(v15) {
        this.mCorePlayer?.setMaxAccurateSeekDelta(v15);
    }
    setCacheConfig(u15) {
        this.mCorePlayer?.setCacheConfig(u15);
    }
    setIPResolveType(t15) {
        this.mCorePlayer?.setIPResolveType(t15);
    }
    setFastStart(s15) {
        this.mCorePlayer?.setFastStart(s15);
    }
    snapShot() {
        this.mCorePlayer?.snapShot();
    }
    clearScreen() {
        this.mCorePlayer?.clearScreen();
    }
    getCacheFilePathByUrl(r15) {
        return this.mCorePlayer?.getCacheFilePathByUrl(r15) ?? '';
    }
    getCacheFilePathByVid(n15, o15, p15, q15) {
        return this.mCorePlayer?.getCacheFilePathByVid(n15, o15, p15, q15) ?? '';
    }
    getPropertyString(m15) {
        return this.mCorePlayer?.getPropertyString(m15) ?? '';
    }
    setDefaultBandWidth(l15) {
        this.mCorePlayer?.setDefaultBandWidth(l15);
    }
    setDefaultResolution(k15) {
        this.mCorePlayer?.setDefaultResolution(k15);
    }
    sendCustomEvent(j15) {
        this.mCorePlayer?.sendCustomEvent(j15);
    }
    setVideoTag(i15) {
        this.mCorePlayer?.setVideoTag(i15);
    }
    setUserData(h15) {
        this.mCorePlayer?.setUserData(h15);
    }
    setTraceId(g15) {
        this.mCorePlayer?.setTraceId(g15);
    }
    getUserData() {
        return this.mCorePlayer?.getUserData() ?? '';
    }
    bindListener() {
        this.mCorePlayer?.setOnPreparedListener(this.mInnerOnPreparedListener);
        this.mCorePlayer?.setOnInfoListener(this.mInnerOnInfoListener);
        this.mCorePlayer?.setOnRenderingStartListener(this.mInnerOnRenderingStartListener);
        this.mCorePlayer?.setOnStateChangedListener(this.mInnerOnStateChangedListener);
        this.mCorePlayer?.setOnVideoSizeChangedListener(this.mInnerOnVideoSizeChangedListener);
        this.mCorePlayer?.setOnLoadingStatusListener(this.mInnerOnLoadingStatusListener);
        this.mCorePlayer?.setOnSeekCompleteListener(this.mInnerOnSeekCompleteListener);
        this.mCorePlayer?.setOnCompletionListener(this.mInnerOnCompletionListener);
        this.mCorePlayer?.setOnVideoRenderedListener(this.mInnerOnVideoRenderedListener);
        this.mCorePlayer?.setOnSubtitleDisplayListener(this.mInnerOnSubtitleDisplayListener);
        this.mCorePlayer?.setOnErrorListener(this.mInnerOnErrorListener);
        this.mCorePlayer?.setOnAudioInterruptEventListener(this.mInnerOnAudioInterruptEventListener);
        this.mCorePlayer?.setOnTrackReadyListener(this.mInnerOnTrackReadyListener);
        this.mCorePlayer?.setOnSubTrackReadyListener(this.mInnerOnSubTrackReadyListener);
        this.mCorePlayer?.setOnStreamSwitchedListener(this.mInnerOnStreamSwitchedListener);
        this.mCorePlayer?.setOnAVNotSyncStatusListener(this.mInnerOnAVNotSyncStatusListener);
        this.mCorePlayer?.setOnTrackChangedListener(this.mInnerOnTrackChangedListener);
        this.mCorePlayer?.setOnSnapShotListener(this.mInnerOnSnapShotListener);
        this.mCorePlayer?.setOnSeiDataListener(this.mInnerOnSeiDataListener);
    }
    setOnPreparedListener(f15) {
        this.mOutOnPreparedListener = f15;
    }
    setOnInfoListener(e15) {
        this.mOutOnInfoListener = e15;
    }
    setOnRenderingStartListener(d15) {
        this.mOutOnRenderingStartListener = d15;
    }
    setOnStateChangedListener(c15) {
        this.mOutOnStateChangedListener = c15;
    }
    setOnCompletionListener(b15) {
        this.mOutOnCompletionListener = b15;
    }
    setOnAVNotSyncStatusListener(a15) {
        this.mOutOnAVNotSyncStatusListener = a15;
    }
    setOnStreamSwitchedListener(z14) {
        this.mOutOnStreamSwitchedListener = z14;
    }
    setOnLoadingStatusListener(y14) {
        this.mOutOnLoadingStatusListener = y14;
    }
    setOnErrorListener(x14) {
        this.mOutOnErrorListener = x14;
    }
    setOnVideoSizeChangedListener(w14) {
        this.mOutOnVideoSizeChangedListener = w14;
    }
    setOnSeekCompleteListener(v14) {
        this.mOutOnSeekCompleteListener = v14;
    }
    setOnSubtitleDisplayListener(u14) {
        this.mOutOnSubtitleDisplayListener = u14;
    }
    setOnVideoRenderedListener(t14) {
        this.mOutOnVideoRenderedListener = t14;
    }
    setOnAudioInterruptEventListener(s14) {
        this.mOutOnAudioInterruptEventListener = s14;
    }
    setOnTrackReadyListener(r14) {
        this.mOutOnTrackReadyListener = r14;
    }
    setOnSubTrackReadyListener(q14) {
        this.mOutOnSubTrackReadyListener = q14;
    }
    setOnTrackChangedListener(p14) {
        this.mOutOnTrackChangedListener = p14;
    }
    setOnSnapShotListener(o14) {
        this.mOutOnSnapShotListener = o14;
    }
    setOnSeiDataListener(n14) {
        this.mOutOnSeiDataListener = n14;
    }
    onPrepared() {
        if (this.mOutOnPreparedListener != null) {
            this.mOutOnPreparedListener.onPrepared();
        }
    }
    onInfo(m14) {
        if (this.mOutOnInfoListener != null) {
            this.mOutOnInfoListener.onInfo(m14);
        }
    }
    onRenderingStart() {
        if (this.mOutOnRenderingStartListener != null) {
            this.mOutOnRenderingStartListener.onRenderingStart();
        }
    }
    onStateChanged(l14) {
        if (this.mOutOnStateChangedListener != null) {
            this.mOutOnStateChangedListener.onStateChanged(l14);
        }
    }
    onVideoSizeChanged(j14, k14) {
        if (this.mOutOnVideoSizeChangedListener != null) {
            this.mOutOnVideoSizeChangedListener.onVideoSizeChanged(j14, k14);
        }
    }
    onLoadingBegin() {
        if (this.mOutOnLoadingStatusListener != null) {
            this.mOutOnLoadingStatusListener.onLoadingBegin();
        }
    }
    onLoadingProgress(h14, i14) {
        if (this.mOutOnLoadingStatusListener != null) {
            this.mOutOnLoadingStatusListener.onLoadingProgress(h14, i14);
        }
    }
    onLoadingEnd() {
        if (this.mOutOnLoadingStatusListener != null) {
            this.mOutOnLoadingStatusListener.onLoadingEnd();
        }
    }
    onSeekEnd() {
        if (this.mOutOnSeekCompleteListener != null) {
            this.mOutOnSeekCompleteListener.onSeekComplete();
        }
    }
    onCompletion() {
        if (this.mOutOnCompletionListener != null) {
            this.mOutOnCompletionListener.onCompletion();
        }
    }
    onVideoRendered(f14, g14) {
        if (this.mOutOnVideoRenderedListener != null) {
            this.mOutOnVideoRenderedListener.onVideoRendered(f14, g14);
        }
    }
    onSubtitleShow(c14, d14, e14) {
        if (this.mOutOnSubtitleDisplayListener != null) {
            this.mOutOnSubtitleDisplayListener.onSubtitleShow(c14, d14, e14);
        }
    }
    onSubtitleExtAdded(a14, b14) {
        if (this.mOutOnSubtitleDisplayListener != null) {
            this.mOutOnSubtitleDisplayListener.onSubtitleExtAdded(a14, b14);
        }
    }
    onSubtitleHide(y13, z13) {
        if (this.mOutOnSubtitleDisplayListener != null) {
            this.mOutOnSubtitleDisplayListener.onSubtitleHide(y13, z13);
        }
    }
    onSubtitleHeader(w13, x13) {
        if (this.mOutOnSubtitleDisplayListener != null) {
            this.mOutOnSubtitleDisplayListener.onSubtitleHeader(w13, x13);
        }
    }
    onError(v13) {
        if (this.mOutOnErrorListener != null) {
            this.mOutOnErrorListener.onError(v13);
        }
    }
    onAudioInterruptEvent(u13) {
        if (this.mOutOnAudioInterruptEventListener != null) {
            this.mOutOnAudioInterruptEventListener.onAudioInterruptEvent(u13);
        }
    }
    onTrackReady(t13) {
        this.mOutMediaInfo = t13;
        if (this.mOutOnTrackReadyListener != null) {
            this.mOutOnTrackReadyListener.onTrackReady(t13);
        }
    }
    onSubTrackReady(s13) {
        this.mOutSubMediaInfo = s13;
        if (this.mOutOnSubTrackReadyListener != null) {
            this.mOutOnSubTrackReadyListener.onSubTrackReady(s13);
        }
    }
    onSwitchedSuccess(r13) {
        if (this.mOutOnStreamSwitchedListener != null) {
            this.mOutOnStreamSwitchedListener.onSwitchedSuccess(r13);
        }
    }
    onSwitchedFail(p13, q13) {
        if (this.mOutOnStreamSwitchedListener != null) {
            this.mOutOnStreamSwitchedListener.onSwitchedFail(p13, q13);
        }
    }
    onAVNotSyncStart(o13) {
        if (this.mOutOnAVNotSyncStatusListener != null) {
            this.mOutOnAVNotSyncStatusListener.onAVNotSyncStart(o13);
        }
    }
    onAVNotSyncEnd() {
        if (this.mOutOnAVNotSyncStatusListener != null) {
            this.mOutOnAVNotSyncStatusListener.onAVNotSyncEnd();
        }
    }
    onChangedSuccess(n13) {
        if (this.mOutOnTrackChangedListener != null) {
            this.mOutOnTrackChangedListener.onChangedSuccess(n13);
        }
    }
    onSnapShot(k13, l13, m13) {
        if (this.mOutOnSnapShotListener != null) {
            this.mOutOnSnapShotListener.onSnapShot(k13, l13, m13);
        }
    }
    onSeiData(i13, j13) {
        if (this.mOutOnSeiDataListener != null) {
            this.mOutOnSeiDataListener.onSeiData(i13, j13);
        }
    }
}
class InnerPrepareListener {
    constructor(h13) {
        this.avbBaseWR = h13;
    }
    onPrepared() {
        if (this.avbBaseWR != null) {
            this.avbBaseWR.onPrepared();
        }
    }
}
class InnerInfoListener {
    constructor(g13) {
        this.avpBaseRef = g13;
    }
    onInfo(f13) {
        if (this.avpBaseRef != null) {
            this.avpBaseRef.onInfo(f13);
        }
    }
}
class InnerRenderingStartListener {
    constructor(e13) {
        this.avpBaseRef = e13;
    }
    onRenderingStart() {
        if (this.avpBaseRef != null) {
            this.avpBaseRef.onRenderingStart();
        }
    }
}
class InnerStateChangedListener {
    constructor(d13) {
        this.avpBaseRef = d13;
    }
    onStateChanged(c13) {
        this.avpBaseRef.onStateChanged(c13);
    }
}
class InnerVideoSizeChangedListener {
    constructor(b13) {
        this.avpBaseRef = b13;
    }
    onVideoSizeChanged(z12, a13) {
        this.avpBaseRef.onVideoSizeChanged(z12, a13);
    }
}
class InnerLoadingStatusListener {
    constructor(y12) {
        this.avpBaseRef = y12;
    }
    onLoadingBegin() {
        this.avpBaseRef.onLoadingBegin();
    }
    onLoadingProgress(w12, x12) {
        this.avpBaseRef.onLoadingProgress(w12, x12);
    }
    onLoadingEnd() {
        this.avpBaseRef.onLoadingEnd();
    }
}
class InnerSeekCompleteListener {
    constructor(v12) {
        this.avpBaseRef = v12;
    }
    onSeekComplete() {
        this.avpBaseRef.onSeekEnd();
    }
}
class InnerCompletionListener {
    constructor(u12) {
        this.avpBaseRef = u12;
    }
    onCompletion() {
        this.avpBaseRef.onCompletion();
    }
}
class InnerVideoRenderedListener {
    constructor(t12) {
        this.avpBaseRef = t12;
    }
    onVideoRendered(r12, s12) {
        this.avpBaseRef.onVideoRendered(r12, s12);
    }
}
class InnerSubtitleDisplayListener {
    constructor(q12) {
        this.avpBaseRef = q12;
    }
    onSubtitleShow(n12, o12, p12) {
        this.avpBaseRef.onSubtitleShow(n12, o12, p12);
    }
    onSubtitleExtAdded(l12, m12) {
        this.avpBaseRef.onSubtitleExtAdded(l12, m12);
    }
    onSubtitleHide(j12, k12) {
        this.avpBaseRef.onSubtitleHide(j12, k12);
    }
    onSubtitleHeader(h12, i12) {
        this.avpBaseRef.onSubtitleHeader(h12, i12);
    }
}
class InnerErrorListener {
    constructor(g12) {
        this.avpBaseRef = g12;
    }
    onError(f12) {
        this.avpBaseRef.onError(f12);
    }
}
class InnerAudioInterruptEventListener {
    constructor(e12) {
        this.avpBaseRef = e12;
    }
    onAudioInterruptEvent(d12) {
        this.avpBaseRef.onAudioInterruptEvent(d12);
    }
}
class InnerTrackReadyListener {
    constructor(c12) {
        this.avpBaseRef = c12;
    }
    onTrackReady(b12) {
        this.avpBaseRef.onTrackReady(b12);
    }
}
class InnerSubTrackReadyListener {
    constructor(a12) {
        this.avpBaseRef = a12;
    }
    onSubTrackReady(z11) {
        this.avpBaseRef.onSubTrackReady(z11);
    }
}
class InnerStreamSwitchedListener {
    constructor(y11) {
        this.avpBaseRef = y11;
    }
    onSwitchedSuccess(x11) {
        this.avpBaseRef.onSwitchedSuccess(x11);
    }
    onSwitchedFail(v11, w11) {
        this.avpBaseRef.onSwitchedFail(v11, w11);
    }
}
class InnerOnAVNotSyncStatusListener {
    constructor(u11) {
        this.avpBaseRef = u11;
    }
    onAVNotSyncStart(t11) {
        this.avpBaseRef.onAVNotSyncStart(t11);
    }
    onAVNotSyncEnd() {
        this.avpBaseRef.onAVNotSyncEnd();
    }
}
class InnerTrackChangedListener {
    constructor(s11) {
        this.avpBaseRef = s11;
    }
    onChangedSuccess(r11) {
        this.avpBaseRef.onChangedSuccess(r11);
    }
}
class InnerSnapShotListener {
    constructor(q11) {
        this.avpBaseRef = q11;
    }
    onSnapShot(n11, o11, p11) {
        this.avpBaseRef.onSnapShot(n11, o11, p11);
    }
}
class InnerSeiDataListener {
    constructor(m11) {
        this.avpBaseRef = m11;
    }
    onSeiData(k11, l11) {
        this.avpBaseRef.onSeiData(k11, l11);
    }
}
