import premierlibrary from 'libpremierlibrary.so';
export class AliPlayerGlobalSettings {
    static getInstance() {
        if (AliPlayerGlobalSettings.sInstance == undefined) {
            AliPlayerGlobalSettings.sInstance = new AliPlayerGlobalSettings();
        }
        return AliPlayerGlobalSettings.sInstance;
    }
    constructor() {
        this.nOnGetUrlHashCallback = (i8) => {
            if (AliPlayerGlobalSettings.sOnGetUrlHashCallback != null) {
                return AliPlayerGlobalSettings.sOnGetUrlHashCallback.getUrlHashCallback(i8);
            }
            else {
                return null;
            }
        };
    }
    static OnGetUrlHashCallback(f8) {
        if (AliPlayerGlobalSettings.sOnGetUrlHashCallback != null) {
            let g8 = AliPlayerGlobalSettings.sOnGetUrlHashCallback.getUrlHashCallback(f8);
            if (g8 != undefined) {
                if (g8.length == 0) {
                    return AliPlayerGlobalSettings.FORBID_URLHASHCB;
                }
                else {
                    return g8;
                }
            }
            else {
                return AliPlayerGlobalSettings.FORBID_URLHASHCB;
            }
        }
        else {
            return AliPlayerGlobalSettings.FORBID_URLHASHCB;
        }
    }
    static getSdkVersion() {
        return premierlibrary.nGetSdkVersion();
    }
    static setOptionStr(d8, e8) {
        premierlibrary.nSetOptionStr(d8, e8);
    }
    static setOptionNum(b8, c8) {
        premierlibrary.nSetOptionInt(b8, c8);
    }
    static setDNSResolve(z7, a8) {
        premierlibrary.nSetDNSResolve(z7, a8);
    }
    static setUseHttp2(y7) {
        premierlibrary.nSetUseHttp2(y7);
    }
    static setIPResolveType(x7) {
        premierlibrary.nGlobalSettingSetIPResolveType(x7);
    }
    static setAudioStreamType(w7) {
        premierlibrary.nSetAudioStreamType(w7);
    }
    static forceAudioRendingFormat(s7, t7, u7, v7) {
        premierlibrary.nForceAudioRendingFormat(s7, t7, u7, v7);
    }
    static enableLocalCache(p7, q7, r7) {
        return premierlibrary.nEnableLocalCache(p7, q7, r7);
    }
    static setCacheFileClearConfig(m7, n7, o7) {
        premierlibrary.nSetCacheFileClearConfig(m7, n7, o7);
    }
    static clearCaches() {
        premierlibrary.nClearCaches();
    }
    static enableHttpDns(l7) {
        premierlibrary.nEnableHttpDns(l7);
    }
    static enableEnhancedHttpDns(k7) {
        premierlibrary.nEnableEnhancedHttpDns(k7);
    }
    static enableNetworkBalance(j7) {
        premierlibrary.nEnableNetworkBalance(j7);
    }
    static enableBufferToLocalCache(i7) {
        premierlibrary.nEnableBufferToLocalCache(i7);
    }
    static disableCrashUpload(h7) {
        premierlibrary.nDisableCrashUpload(h7);
    }
    static setCacheUrlHashCallback(g7) {
        AliPlayerGlobalSettings.sOnGetUrlHashCallback = g7;
        premierlibrary.nSetCacheUrlHashCallback(AliPlayerGlobalSettings.getInstance(), g7 != null);
    }
}
AliPlayerGlobalSettings.SET_PRE_CONNECT_DOMAIN = 0;
AliPlayerGlobalSettings.SET_DNS_PRIORITY_LOCAL_FIRST = 1;
AliPlayerGlobalSettings.ENABLE_H2_MULTIPLEX = 2;
AliPlayerGlobalSettings.SET_EXTRA_DATA = 3;
AliPlayerGlobalSettings.ENABLE_ANDROID_DECODE_REUSE = 4;
AliPlayerGlobalSettings.NOT_PAUSE_WHEN_PREPARING = 5;
AliPlayerGlobalSettings.ALLOW_RTS_DEGRADE = 6;
AliPlayerGlobalSettings.ENABLE_DECODER_FAST_FIRST_FRAME = 7;
AliPlayerGlobalSettings.DISABLE_CAPTURE_SCALE = 8;
AliPlayerGlobalSettings.MAX_ERROR_FRAMES_HARDWARE_DECODE = 15;
AliPlayerGlobalSettings.SCENE_PLAYER = 0;
AliPlayerGlobalSettings.SCENE_LOADER = 1;
AliPlayerGlobalSettings.CodecType_H265 = 0;
AliPlayerGlobalSettings.FORBID_URLHASHCB = "forbid_UseUrlHashCb";
AliPlayerGlobalSettings.sOnGetUrlHashCallback = null;
export var AudioStreamType;
(function (f7) {
    f7[f7["AUDIOSTREAM_USAGE_UNKNOWN"] = 0] = "AUDIOSTREAM_USAGE_UNKNOWN";
    f7[f7["AUDIOSTREAM_USAGE_MUSIC"] = 1] = "AUDIOSTREAM_USAGE_MUSIC";
    f7[f7["AUDIOSTREAM_USAGE_VOICE_COMMUNICATION"] = 2] = "AUDIOSTREAM_USAGE_VOICE_COMMUNICATION";
    f7[f7["AUDIOSTREAM_USAGE_VOICE_ASSISTANT"] = 3] = "AUDIOSTREAM_USAGE_VOICE_ASSISTANT";
    f7[f7["AUDIOSTREAM_USAGE_ALARM"] = 4] = "AUDIOSTREAM_USAGE_ALARM";
    f7[f7["AUDIOSTREAM_USAGE_VOICE_MESSAGE"] = 5] = "AUDIOSTREAM_USAGE_VOICE_MESSAGE";
    f7[f7["AUDIOSTREAM_USAGE_RINGTONE"] = 6] = "AUDIOSTREAM_USAGE_RINGTONE";
    f7[f7["AUDIOSTREAM_USAGE_NOTIFICATION"] = 7] = "AUDIOSTREAM_USAGE_NOTIFICATION";
    f7[f7["AUDIOSTREAM_USAGE_ACCESSIBILITY"] = 8] = "AUDIOSTREAM_USAGE_ACCESSIBILITY";
    f7[f7["AUDIOSTREAM_USAGE_MOVIE"] = 10] = "AUDIOSTREAM_USAGE_MOVIE";
    f7[f7["AUDIOSTREAM_USAGE_GAME"] = 11] = "AUDIOSTREAM_USAGE_GAME";
    f7[f7["AUDIOSTREAM_USAGE_AUDIOBOOK"] = 12] = "AUDIOSTREAM_USAGE_AUDIOBOOK";
    f7[f7["AUDIOSTREAM_USAGE_NAVIGATION"] = 13] = "AUDIOSTREAM_USAGE_NAVIGATION";
    f7[f7["AUDIOSTREAM_USAGE_VIDEO_COMMUNICATION"] = 17] = "AUDIOSTREAM_USAGE_VIDEO_COMMUNICATION";
})(AudioStreamType || (AudioStreamType = {}));
