import { UrlVideoPlayer } from './UrlVideoPlayer';
import { OhosSaasPlayer } from './nativeclass/OhosSaasPlayer';
import { LiveSts } from './source/LiveSts';
import { VidAuth } from './source/VidAuth';
import { VidMps } from './source/VidMps';
import { VidSts } from './source/VidSts';
import { StsInfo } from './source/StsInfo';
export class ApsaraVideoPlayer extends UrlVideoPlayer {
    constructor(i11, j11) {
        super(i11, j11);
    }
    setVidAuthDataSource(g11) {
        let h11 = this.getCorePlayer();
        if (h11 instanceof OhosSaasPlayer) {
            if (g11 instanceof VidAuth) {
                h11.setVidAuthSource(g11);
            }
        }
    }
    setVidStsDataSource(e11) {
        let f11 = this.getCorePlayer();
        if (f11 instanceof OhosSaasPlayer) {
            if (e11 instanceof VidSts) {
                f11.setVidStsSource(e11);
            }
        }
    }
    setVidMpsDataSource(c11) {
        let d11 = this.getCorePlayer();
        if (d11 instanceof OhosSaasPlayer) {
            if (c11 instanceof VidMps) {
                d11.setVidMpsSource(c11);
            }
        }
    }
    setLiveStsDataSource(a11) {
        let b11 = this.getCorePlayer();
        if (b11 instanceof OhosSaasPlayer) {
            if (a11 instanceof LiveSts) {
                b11.setLiveStsDataSource(a11);
            }
        }
    }
    updateVidAuth(y10) {
        let z10 = this.getCorePlayer();
        if (z10 instanceof OhosSaasPlayer) {
            if (y10 instanceof VidAuth) {
                z10.updateVidAuth(y10);
            }
        }
    }
    updateStsInfo(w10) {
        let x10 = this.getCorePlayer();
        if (x10 instanceof OhosSaasPlayer) {
            if (w10 instanceof StsInfo) {
                x10.updateStsInfo(w10);
            }
        }
    }
    createAlivcMediaPlayer(u10) {
        let v10 = new OhosSaasPlayer(u10);
        return v10;
    }
}
