import premierlibrary from 'libpremierlibrary.so';
import { Log } from '../../utils/Log';
import { Option, AudioStatus, } from '../IPlayer';
import { InfoBean } from '../bean/InfoBean';
import { findInfoCodeByValue, InfoCode } from '../bean/InfoCode';
import { findErrorCodeByValue } from '../bean/PlayerErrorCode';
import { ErrorInfo } from '../bean/ErrorInfo';
import { ObjCreateHelper } from '../../utils/ObjCreateHelper';
const log = new Log('NativePlayerBase');
export class NativePlayerBase {
    constructor(s26) {
        this.mNativeContext = 0;
        this.objHelper = new ObjCreateHelper();
        this.getNativeContext = () => {
            log.info(`getNativeContext, address: ${this.mNativeContext}`);
            return this.mNativeContext;
        };
        this.setNativeContext = (e30) => {
            log.info(`setNativeContext, address: ${e30}`);
            this.mNativeContext = e30;
        };
        this.getHelper = () => {
            log.info(`getHelper`);
            return this.objHelper;
        };
        this.getContext = () => {
            log.info(`getNativeContext, address: ${this.mNativeContext}`);
            return this.mContext;
        };
        this.onPrepared = () => {
            console.log('onPrepared called at nativePlayerBase.');
            if (this.mOnPreparedListener != null) {
                this.mOnPreparedListener.onPrepared();
            }
        };
        this.onCircleStart = () => {
            if (this.mOnInfoListener != null) {
                let d30 = new InfoBean();
                d30.setCode(InfoCode.LoopingStart);
                this.mOnInfoListener.onInfo(d30);
            }
        };
        this.onAutoPlayStart = () => {
            if (this.mOnInfoListener != null) {
                let c30 = new InfoBean();
                c30.setCode(InfoCode.AutoPlayStart);
                this.mOnInfoListener.onInfo(c30);
            }
        };
        this.onEvent = (y29, z29) => {
            if (this.mOnInfoListener != null) {
                let a30 = findInfoCodeByValue(y29);
                let b30 = new InfoBean();
                b30.setCode(a30);
                b30.setExtraMsg(z29);
                this.mOnInfoListener.onInfo(b30);
            }
        };
        this.onCurrentDownloadSpeed = (w29) => {
            if (this.mOnInfoListener != null) {
                let x29 = new InfoBean();
                x29.setCode(InfoCode.CurrentDownloadSpeed);
                x29.setExtraValue(w29);
                this.mOnInfoListener.onInfo(x29);
            }
        };
        this.onUtcTimeUpdate = (u29) => {
            if (this.mOnInfoListener != null) {
                let v29 = new InfoBean();
                v29.setCode(InfoCode.UtcTime);
                v29.setExtraValue(u29);
                this.mOnInfoListener.onInfo(v29);
            }
        };
        this.onLocalCacheLoad = (s29) => {
            if (this.mOnInfoListener != null) {
                let t29 = new InfoBean();
                t29.setCode(InfoCode.LocalCacheLoaded);
                t29.setExtraValue(s29);
                this.mOnInfoListener.onInfo(t29);
            }
        };
        this.onBufferedPositionUpdate = (q29) => {
            if (this.mOnInfoListener != null) {
                let r29 = new InfoBean();
                r29.setCode(InfoCode.BufferedPosition);
                r29.setExtraValue(q29);
                this.mOnInfoListener.onInfo(r29);
            }
        };
        this.onCurrentPositionUpdate = (o29) => {
            if (this.mOnInfoListener != null) {
                let p29 = new InfoBean();
                p29.setCode(InfoCode.CurrentPosition);
                p29.setExtraValue(o29);
                this.mOnInfoListener.onInfo(p29);
            }
        };
        this.onFirstFrameShow = () => {
            if (this.mOnRenderingStartListener != null) {
                this.mOnRenderingStartListener.onRenderingStart();
            }
        };
        this.onVideoSizeChanged = (m29, n29) => {
            if (this.mOnVideoSizeChangedListener != null) {
                this.mOnVideoSizeChangedListener.onVideoSizeChanged(m29, n29);
            }
        };
        this.onAudioInterruptEvent = (l29) => {
            if (this.mOnAudioInterruptEventListener != null) {
                if (l29 < AudioStatus.AUDIO_STATUS_DEFAULT || l29 > AudioStatus.AUDIO_STATUS_UNDUCK) {
                    log.info('onAudioInterruptEvent exception audioStatus: ' + l29);
                    this.mOnAudioInterruptEventListener.onAudioInterruptEvent(AudioStatus.AUDIO_STATUS_DEFAULT);
                    return;
                }
                this.mOnAudioInterruptEventListener.onAudioInterruptEvent(l29);
            }
        };
        this.onLoadingStart = () => {
            if (this.mOnLoadingStatusListener != null) {
                this.mOnLoadingStatusListener.onLoadingBegin();
            }
        };
        this.onLoadingProgress = (k29) => {
            if (this.mOnLoadingStatusListener != null) {
                this.mOnLoadingStatusListener.onLoadingProgress(k29, 0);
            }
        };
        this.onLoadingEnd = () => {
            if (this.mOnLoadingStatusListener != null) {
                this.mOnLoadingStatusListener.onLoadingEnd();
            }
        };
        this.onAVNotSyncStart = (j29) => {
            if (this.mOnAVNotSyncStatusListener != null) {
                this.mOnAVNotSyncStatusListener.onAVNotSyncStart(j29);
            }
        };
        this.onAVNotSyncEnd = (i29) => {
            if (this.mOnAVNotSyncStatusListener != null) {
                this.mOnAVNotSyncStatusListener.onAVNotSyncEnd();
            }
        };
        this.onSeekEnd = () => {
            if (this.mOnSeekCompleteListener != null) {
                this.mOnSeekCompleteListener.onSeekComplete();
            }
        };
        this.onStatusChanged = (g29, h29) => {
            log.info('onStatusChanged, newState: ' + g29 + ' oldState: ' + h29);
            if (this.mOnStateChangedListener != null) {
                this.mOnStateChangedListener.onStateChanged(g29);
            }
        };
        this.onCompletion = () => {
            if (this.mOnCompletionListener != null) {
                this.mOnCompletionListener.onCompletion();
            }
        };
        this.onVideoRendered = (e29, f29) => {
            if (this.mOnVideoRenderedListener != null) {
                this.mOnVideoRenderedListener.onVideoRendered(e29, f29);
            }
        };
        this.onShowSubtitle = (b29, c29, d29) => {
            if (this.mOnSubtitleDisplayListener != null) {
                this.mOnSubtitleDisplayListener.onSubtitleShow(b29, c29, d29);
            }
        };
        this.onSubtitleExtAdded = (z28, a29) => {
            if (this.mOnSubtitleDisplayListener != null) {
                this.mOnSubtitleDisplayListener.onSubtitleExtAdded(z28, a29);
            }
        };
        this.onHideSubtitle = (x28, y28) => {
            if (this.mOnSubtitleDisplayListener != null) {
                this.mOnSubtitleDisplayListener.onSubtitleHide(x28, y28);
            }
        };
        this.onSubtitleHeader = (v28, w28) => {
            if (this.mOnSubtitleDisplayListener != null) {
                this.mOnSubtitleDisplayListener.onSubtitleHeader(v28, w28);
            }
        };
        this.onError = (q28, r28, s28) => {
            let t28 = findErrorCodeByValue(q28);
            if (this.mOnErrorListener != null) {
                let u28 = new ErrorInfo();
                u28.setCode(t28);
                u28.setMsg(r28);
                u28.setExtra(s28);
                this.mOnErrorListener.onError(u28);
            }
        };
        this.onStreamSwitchSuc = (p28) => {
            if (this.mOnTrackChangedListener != null) {
                this.mOnTrackChangedListener.onChangedSuccess(p28);
            }
        };
        this.onStreamInfoGet = (o28) => {
            if (this.mOnTrackReadyListener != null) {
                this.mOnTrackReadyListener.onTrackReady(o28);
            }
        };
        this.onSubStreamInfoGet = (n28) => {
            if (this.mOnSubTrackReadyListener != null) {
                this.mOnSubTrackReadyListener.onSubTrackReady(n28);
            }
        };
        this.onSwitchStreamUrlResult = (i28, j28, k28) => {
            if (this.mOnStreamSwitchedListener == null) {
                return;
            }
            if (j28 == 0) {
                this.mOnStreamSwitchedListener.onSwitchedSuccess(i28);
            }
            else {
                let l28 = findErrorCodeByValue(j28);
                let m28 = new ErrorInfo();
                m28.setCode(l28);
                m28.setMsg(k28);
                this.mOnStreamSwitchedListener.onSwitchedFail(i28, m28);
            }
        };
        this.onCaptureScreen = (f28, g28, h28) => {
            if (this.mOnSnapShotListener != null) {
                this.mOnSnapShotListener.onSnapShot(h28, f28, g28);
            }
        };
        this.onSeiDataCallback = (d28, e28) => {
            if (this.mOnSeiDataListener != null) {
                this.mOnSeiDataListener.onSeiData(d28, new Uint8Array(e28));
            }
        };
        log.info('constructor_');
        this.mContext = s26;
        premierlibrary.nConstruct(this);
    }
    setOnPreparedListener(r26) {
        this.mOnPreparedListener = r26;
    }
    setOnInfoListener(q26) {
        this.mOnInfoListener = q26;
    }
    setOnRenderingStartListener(p26) {
        this.mOnRenderingStartListener = p26;
    }
    setOnStateChangedListener(o26) {
        this.mOnStateChangedListener = o26;
    }
    setOnCompletionListener(n26) {
        this.mOnCompletionListener = n26;
    }
    setOnLoadingStatusListener(m26) {
        this.mOnLoadingStatusListener = m26;
    }
    setOnErrorListener(l26) {
        this.mOnErrorListener = l26;
    }
    setOnVideoSizeChangedListener(k26) {
        this.mOnVideoSizeChangedListener = k26;
    }
    setOnSeekCompleteListener(j26) {
        this.mOnSeekCompleteListener = j26;
    }
    setOnSubtitleDisplayListener(i26) {
        this.mOnSubtitleDisplayListener = i26;
    }
    setOnVideoRenderedListener(h26) {
        this.mOnVideoRenderedListener = h26;
    }
    setOnAudioInterruptEventListener(g26) {
        this.mOnAudioInterruptEventListener = g26;
    }
    setOnTrackReadyListener(f26) {
        this.mOnTrackReadyListener = f26;
    }
    setOnSubTrackReadyListener(e26) {
        this.mOnSubTrackReadyListener = e26;
    }
    setOnStreamSwitchedListener(d26) {
        this.mOnStreamSwitchedListener = d26;
    }
    setOnAVNotSyncStatusListener(c26) {
        this.mOnAVNotSyncStatusListener = c26;
    }
    setOnTrackChangedListener(b26) {
        this.mOnTrackChangedListener = b26;
    }
    setOnSnapShotListener(a26) {
        this.mOnSnapShotListener = a26;
    }
    setOnSeiDataListener(z25) {
        this.mOnSeiDataListener = z25;
    }
    start() {
        log.info('nStart');
        premierlibrary.nStart(this);
    }
    pause() {
        log.info('nPause');
        premierlibrary.nPause(this);
    }
    stop() {
        log.info('nStop');
        premierlibrary.nStop(this);
    }
    prepare() {
        log.info('nPrepare');
        premierlibrary.nPrepare(this);
    }
    setAutoPlay(y25) {
        log.info('nPrepare');
        premierlibrary.nSetAutoPlay(this, y25);
    }
    setSurfaceId(x25) {
        log.info('nSetSurfaceId');
        premierlibrary.nSetSurfaceId(this, x25);
    }
    setSpeed(w25) {
        log.info('setSpeed');
        premierlibrary.nSetSpeed(this, w25);
    }
    switchStream(v25) {
        log.info('switchStream');
        premierlibrary.nSwitchStream(this, v25);
    }
    setAlphaRenderMode(u25) {
        log.info('setAlphaRenderMode');
        premierlibrary.nSetAlphaRenderMode(this, u25);
    }
    getAlphaRenderMode() {
        log.info('getAlphaRenderMode');
        return premierlibrary.nGetAlphaRenderMode(this);
    }
    selectTrack(t25) {
        log.info('selectTrack');
        premierlibrary.nSelectTrack(this, t25);
    }
    getCurrentTrack(r25) {
        log.info('getCurrentTrack, type: ' + r25);
        let s25 = premierlibrary.nGetCurrentStreamInfo(this, r25);
        return s25;
    }
    addExtSubtitle(q25) {
        log.info(`addExtSubtitle`);
        premierlibrary.nAddExtSubtitle(this, q25);
    }
    selectExtSubtitle(o25, p25) {
        log.info(`selectExtSubtitle`);
        premierlibrary.nSelectExtSubtitle(this, o25, p25);
    }
    setVolume(n25) {
        log.info('setVolume');
        premierlibrary.nSetVolume(this, n25);
    }
    getVolume() {
        log.info('getVolume');
        return premierlibrary.nGetVolume(this);
    }
    seekTo(l25, m25) {
        log.info('seekTo');
        premierlibrary.nSeekTo(this, l25, m25);
    }
    setStartTime(j25, k25) {
        log.info('setStartTime');
        premierlibrary.nSetStartTime(this, j25, k25);
    }
    getDuration() {
        log.info('getDuration');
        return premierlibrary.nGetDuration(this);
    }
    setGlobalTime(i25) {
        premierlibrary.nSetGlobalTime(this, i25);
    }
    getPlayedDuration() {
        log.info('getPlayedDuration');
        return premierlibrary.nGetPlayedDuration(this);
    }
    getCurrentPosition() {
        log.info('getCurrentPosition');
        return premierlibrary.nGetCurrentPosition(this);
    }
    getBufferedPosition() {
        log.info('getBufferedPosition');
        return premierlibrary.nGetBufferedPosition(this);
    }
    getPlayerStatus() {
        log.info('getPlayerStatus');
        return premierlibrary.nGetPlayerStatus(this);
    }
    setTraceId(h25) {
        log.info('setTraceId');
        premierlibrary.nSetTraceId(this, h25);
    }
    enableHardwareDecoder(g25) {
        log.info('enableHardwareDecoder');
        premierlibrary.nEnableHardwareDecoder(this, g25);
    }
    release() {
        log.info('release');
        premierlibrary.nRelease(this);
    }
    setMute(f25) {
        log.info('setMute');
        premierlibrary.nSetMute(this, f25);
    }
    isMuted() {
        log.info('isMuted');
        return premierlibrary.nIsMuted(this) === 1;
    }
    setScaleMode(e25) {
        log.info('setScaleMode');
        premierlibrary.nSetScaleMode(this, e25);
    }
    getScaleMode() {
        log.info('getScaleMode');
        return premierlibrary.nGetScaleMode(this);
    }
    setLoop(d25) {
        log.info('setLoop');
        premierlibrary.nSetLoop(this, d25);
    }
    isLoop() {
        log.info('isLoop');
        return premierlibrary.nIsLoop(this) === 1;
    }
    getVideoWidth() {
        log.info('getVideoWidth');
        return premierlibrary.nGetVideoWidth(this);
    }
    getVideoHeight() {
        log.info('getVideoHeight');
        return premierlibrary.nGetVideoHeight(this);
    }
    getVideoRotation() {
        log.info('getVideoRotation');
        return premierlibrary.nGetVideoRotation(this);
    }
    reload() {
        log.info('reload');
        premierlibrary.nReload(this);
    }
    setRotateMode(c25) {
        log.info('setRotateMode');
        premierlibrary.nSetRotateMode(this, c25);
    }
    getRotateMode() {
        log.info('getRotateMode');
        return premierlibrary.nGetRotateMode(this);
    }
    setMirrorMode(b25) {
        log.info('setMirrorMode');
        premierlibrary.nSetMirrorMode(this, b25);
    }
    getMirrorMode() {
        log.info('getMirrorMode');
        return premierlibrary.nGetMirrorMode(this);
    }
    setVideoBackgroundColor(a25) {
        log.info('setVideoBackgroundColor');
        premierlibrary.nSetVideoBackgroundColor(this, a25);
    }
    getSpeed() {
        log.info('getSpeed');
        return premierlibrary.nGetSpeed(this);
    }
    isAutoPlay() {
        log.info('isAutoPlay');
        return premierlibrary.nIsAutoPlay(this) === 1;
    }
    setConfig(z24) {
        log.info('setConfig');
        premierlibrary.nSetConfig(this, z24);
        this.mPlayerConfig = z24;
    }
    getConfig() {
        log.info('getConfig');
        let y24 = premierlibrary.nGetConfig(this);
        return y24;
    }
    setPlayerScene(x24) {
        log.info('setPlayerScene');
        premierlibrary.nSetPlayerScene(this, x24);
    }
    setOption(v24, w24) {
        log.info('setOption');
        premierlibrary.nSetOption(this, v24, w24);
    }
    getOption(s24) {
        let t24 = premierlibrary.nGetOption(this, s24);
        if (s24 == Option.RenderFPS ||
            s24 == Option.DownloadBitrate ||
            s24 == Option.VideoBitrate ||
            s24 == Option.AudioBitrate) {
            let u24 = parseFloat(t24);
            return u24;
        }
        return t24;
    }
    setStreamDelay(q24, r24) {
        log.info('setStreamDelay');
        premierlibrary.nSetStreamDelay(this, q24, r24);
    }
    setMaxAccurateSeekDelta(p24) {
        log.info('setMaxAccurateSeekDelta');
        premierlibrary.nSetMaxAccurateSeekDelta(this, p24);
    }
    setCacheConfig(o24) {
        log.info('setCacheConfig');
        premierlibrary.nSetCacheConfig(this, o24);
    }
    setIPResolveType(n24) {
        log.info('setIPResolveType');
        premierlibrary.nSetIPResolveType(this, n24);
    }
    setFastStart(m24) {
        log.info('setFastStart');
        premierlibrary.nSetFastStart(this, m24);
    }
    snapShot() {
        log.info('snapShot');
        premierlibrary.nSnapShot(this);
    }
    clearScreen() {
        log.info('clearScreen');
        premierlibrary.nClearScreen(this);
    }
    getSdkVersion() {
        log.info('getSdkVersion');
        return premierlibrary.nGetSdkVersion();
    }
    getCacheFilePathByUrl(l24) {
        log.info('getCacheFilePathByUrl');
        return premierlibrary.nGetCacheFilePathByUrl(this, l24);
    }
    getCacheFilePathByVid(h24, i24, j24, k24) {
        log.info('getCacheFilePathByVid');
        return premierlibrary.nGetCacheFilePathByVid(this, h24, i24, j24, k24);
    }
    getPropertyString(g24) {
        log.info('getPropertyString');
        return premierlibrary.nGetPropertyString(this, g24);
    }
    setDefaultBandWidth(f24) {
        log.info('setDefaultBandWidth');
        premierlibrary.nSetDefaultBandWidth(this, f24);
    }
    setDefaultResolution(e24) {
        log.info('setDefaultResolution');
        premierlibrary.nSetDefaultResolution(this, e24);
    }
    sendCustomEvent(d24) {
        log.info('sendCustomEvent');
        premierlibrary.nSendCustomEvent(this, d24);
    }
    setVideoTag(c24) {
        log.info('setVideoTag');
        premierlibrary.nSetVideoTag(this, c24);
    }
    setUserData(b24) {
        log.info('setUserData');
        premierlibrary.nSetUserData(this, b24);
    }
    getUserData() {
        log.info('getUserData');
        return premierlibrary.nGetUserData(this);
    }
    getNativeContextAddr() {
        return this.mNativeContext;
    }
}
