import { SourceBase } from './SourceBase';
import { Definition } from './Definition';
export class VidSourceBase extends SourceBase {
    constructor() {
        super();
        this.mPlayConfig = null;
        this.mOutputType = null;
        this.mStreamTypes = null;
        this.mResultType = null;
        this.mDigitalWatermarkType = null;
        this.nativeGetOutputTypeStr = () => {
            if (this.mOutputType == null) {
                return "";
            }
            else {
                return this.mOutputType.toString();
            }
        };
        this.nativeGetReAuthInfoStr = () => {
            return this.mReAuthInfo;
        };
        this.nativeGetResultTypeStr = () => {
            if (this.mResultType == null) {
                return "";
            }
            else {
                return this.mResultType;
            }
        };
        this.nativeGetStreamTypeStr = () => {
            if (this.mStreamTypes == null || this.mStreamTypes.size == 0) {
                return "";
            }
            let f40 = "";
            for (let g40 of this.mStreamTypes) {
                if (g40 != null) {
                    f40 += g40 + ",";
                }
            }
            if (f40.length > 0) {
                f40 = f40.slice(0, -1);
            }
            return f40;
        };
        this.nativeGetDefinitionStr = () => {
            if (this.mDefinitions == null || this.mDefinitions.length == 0) {
                return "";
            }
            if (this.mDefinitions.includes(Definition.DEFINITION_AUTO, 0)) {
                return Definition.DEFINITION_AUTO;
            }
            let d40 = "";
            for (let e40 of this.mDefinitions) {
                if (e40 != null) {
                    d40 += e40 + ",";
                }
            }
            if (d40.length > 0) {
                d40 = d40.slice(0, -1);
            }
            return d40;
        };
        this.nativeGetPlayerConfigStr = () => {
            if (this.mPlayConfig == null) {
                return "";
            }
            else {
                return this.mPlayConfig.genConfig();
            }
        };
        this.nativeGetFormatStr = () => {
            return this.getFormatStr();
        };
        this.nativeGetAuthTimeout = () => {
            return this.mAuthTimeout;
        };
        this.nativeGetTrace = () => {
            return this.mTrace;
        };
        this.nativeGetDigitalWatermarkTypeStr = () => {
            if (this.mDigitalWatermarkType == null) {
                return "";
            }
            else {
                return this.mDigitalWatermarkType.toString();
            }
        };
        this.mFormats = [];
        this.mDefinitions = [];
        this.mReAuthInfo = "";
        this.mAuthTimeout = 3600;
        this.mTrace = "";
    }
    getPlayerConfig() {
        if (this.mPlayConfig == null) {
            return "";
        }
        else {
            return this.mPlayConfig.genConfig();
        }
    }
    setPlayerConfig(s39) {
        this.mPlayConfig = s39;
    }
    getFormats() {
        return this.mFormats;
    }
    setFormats(r39) {
        this.mFormats = r39;
    }
    getFormatStr() {
        if (this.mFormats.length == 0) {
            return "";
        }
        let p39 = "";
        for (let q39 of this.mFormats) {
            if (q39 != null) {
                p39 += q39 + ",";
            }
        }
        if (p39.length > 0) {
            p39 = p39.slice(0, -1);
        }
        return p39;
    }
    setDefinition(o39) {
        this.mDefinitions = o39;
    }
    getOutputType() {
        return this.mOutputType;
    }
    setOutputType(n39) {
        this.mOutputType = n39;
    }
    setAuthTimeout(m39) {
        this.mAuthTimeout = m39;
    }
    setTrace(l39) {
        this.mTrace = l39;
    }
    setDigitalWatermarkType(k39) {
        this.mDigitalWatermarkType = k39;
    }
    getTrace() {
        return this.mTrace;
    }
    getDigitalWatermarkType() {
        return this.mDigitalWatermarkType;
    }
}
export var OutputType;
(function (j39) {
    j39["oss"] = "oss";
    j39["cdn"] = "cdn";
})(OutputType || (OutputType = {}));
export var StreamType;
(function (i39) {
    i39["video"] = "video";
    i39["audio"] = "audio";
})(StreamType || (StreamType = {}));
export var ResultType;
(function (h39) {
    h39["Single"] = "Single";
    h39["Multiple"] = "Multiple";
})(ResultType || (ResultType = {}));
export var DigitalWatermarkType;
(function (g39) {
    g39["TraceMark"] = "TraceMark";
    g39["CopyrightMark"] = "CopyrightMark";
})(DigitalWatermarkType || (DigitalWatermarkType = {}));
