export class BaseRequest {
    constructor(n43) {
        this.wantStop = false;
        this.outerListener = null;
        this.outerListener = n43;
    }
    getSync() {
        this.runInBackground();
    }
    getAsync() {
        this.runInBackgroundAsync();
    }
    runInBackgroundAsync() {
        setTimeout(() => {
            this.runInBackground();
        }, 0);
    }
    stop() {
        this.wantStop = true;
        this.stopInner();
    }
    sendSuccessResult(k43, l43) {
        if (this.wantStop) {
            return;
        }
        if (this.outerListener) {
            this.outerListener.onSuccess(k43, l43);
        }
    }
    sendFailResult(h43, i43, j43) {
        if (this.wantStop) {
            return;
        }
        if (this.outerListener) {
            this.outerListener.onFail(h43, i43, j43);
        }
    }
    dealMsg(g43) {
        if (g43.id == BaseRequest.WHAT_SUCCESS) {
            this.outerListener?.onSuccess(g43.data, g43.extra);
        }
        else if (g43.id == BaseRequest.WHAT_FAIL) {
            this.outerListener?.onFail(g43.failCode, g43.data, g43.extra);
        }
    }
}
BaseRequest.WHAT_SUCCESS = 1;
BaseRequest.WHAT_FAIL = 0;
BaseRequest.DATA_KEY_EXTRA = "data_extra";
