import http from '@ohos.net.http';
import util from "@ohos.util";
export class HttpClientHelper {
    constructor(k44) {
        this.mReferer = null;
        this.urlRequest = null;
        this.mNetworkTimeout = HttpClientHelper.CONNECTION_TIMEOUT;
        this.mHttpProxy = null;
        this.mUserAgent = null;
        this.mCustomHeaders = [{}];
        this.mUrl = k44;
    }
    setRefer(j44) {
        this.mReferer = j44;
    }
    setTimeout(i44) {
        this.mNetworkTimeout = i44;
    }
    setHttpProxy(h44) {
        this.mHttpProxy = h44;
    }
    setUserAgent(g44) {
        this.mUserAgent = g44;
    }
    setCustomHeaders(f44) {
        this.mCustomHeaders = f44;
    }
    stop() {
        if (this.urlRequest != null) {
            setTimeout(() => {
                this.urlRequest?.destroy();
            }, 0);
        }
    }
    async doGet() {
        if (this.mUrl.startsWith("https://") || this.mUrl.startsWith("http://")) {
            this.urlRequest = http.createHttp();
        }
        else {
            return null;
        }
        if (this.urlRequest == null) {
            return null;
        }
        let r43 = [];
        if (this.mReferer != null) {
            r43.push({ 'Referer': this.mReferer });
        }
        if (this.mUserAgent != null) {
            r43.push({ 'User-Agent': this.mUserAgent });
        }
        if (this.mCustomHeaders.length > 0) {
            for (let d44 of this.mCustomHeaders) {
                if (d44 != null) {
                    r43.push(d44);
                }
            }
        }
        let s43 = "";
        let t43 = false;
        if (this.mHttpProxy != null) {
            s43 = this.mHttpProxy;
            t43 = true;
        }
        else {
            s43 = this.mUrl;
        }
        let u43 = {
            method: http.RequestMethod.GET,
            header: r43,
            connectTimeout: this.mNetworkTimeout,
            readTimeout: this.mNetworkTimeout,
            usingProxy: t43,
        };
        return new Promise((w43, x43) => {
            if (this.urlRequest == null) {
                w43(null);
                return;
            }
            this.urlRequest.request(s43, u43, (z43, a44) => {
                if (z43) {
                    console.error('error:' + JSON.stringify(z43));
                    this.urlRequest?.destroy();
                    w43(null);
                    return;
                }
                if (a44.responseCode == http.ResponseCode.OK) {
                    if (a44.resultType == http.HttpDataType.STRING) {
                        w43(a44.result);
                    }
                    else if (a44.resultType == http.HttpDataType.ARRAY_BUFFER) {
                        let b44 = util.TextDecoder.create('utf-8');
                        let c44 = b44.decodeToString(new Uint8Array(a44.result));
                        w43(c44 ? c44 : null);
                    }
                    else {
                        console.info("response failed, resultType: " + a44.resultType);
                        this.urlRequest?.destroy();
                        w43(null);
                    }
                }
                else {
                    console.info("response failed, responseCode is " + a44.responseCode);
                    this.urlRequest?.destroy();
                    w43(null);
                }
            });
        });
    }
}
HttpClientHelper.CONNECTION_TIMEOUT = 10000;
