import premierlibrary from 'libpremierlibrary.so';
export class Logger {
    constructor() {
        this.mValue = -1;
        this.mLogCallback = null;
        this.mEnableConsoleLog = true;
        this.mCurrentLogLevel = LogLevel.AF_LOG_LEVEL_INFO;
        this.nOnLogCallback = (e45, f45) => {
            let g45 = Logger.getLevel(e45);
            if (Logger.sAppContext != null) {
                Logger.getInstance(Logger.sAppContext).callback(g45, f45);
            }
        };
        premierlibrary.nLoggerConstruct(this);
    }
    static getInstance(c45) {
        if (Logger.sInstance == null) {
            Logger.sInstance = new Logger();
            Logger.sInstance.setLogLevel(LogLevel.AF_LOG_LEVEL_INFO);
            if (c45 != null) {
                Logger.sAppContext = c45;
            }
        }
        return Logger.sInstance;
    }
    setLogCallback(b45) {
        this.mLogCallback = b45;
    }
    getLogCallback() {
        return this.mLogCallback;
    }
    setLogLevel(a45) {
        this.mCurrentLogLevel = a45;
        premierlibrary.nLoggerSetLevel(a45);
    }
    setLogOption(y44, z44) {
        switch (y44) {
            case LogOption.FRAME_LEVEL_LOGGING_ENABLED:
                premierlibrary.nLoggerSetOption("frame_level_logging_enabled", z44);
                break;
        }
    }
    getLogLevel() {
        let x44 = premierlibrary.nLoggerGetLevel();
        return Logger.getLevel(x44);
    }
    enableConsoleLog(w44) {
        this.mEnableConsoleLog = w44;
        premierlibrary.nLoggerEnableConsole(w44);
    }
    callback(u44, v44) {
        if (this.mLogCallback != null) {
            this.mLogCallback.onLog(u44, v44);
        }
    }
    static getLevel(t44) {
        switch (t44) {
            case 0:
                return LogLevel.AF_LOG_LEVEL_NONE;
            case 8:
                return LogLevel.AF_LOG_LEVEL_FATAL;
            case 16:
                return LogLevel.AF_LOG_LEVEL_ERROR;
            case 24:
                return LogLevel.AF_LOG_LEVEL_WARNING;
            case 32:
                return LogLevel.AF_LOG_LEVEL_INFO;
            case 48:
                return LogLevel.AF_LOG_LEVEL_DEBUG;
            case 56:
                return LogLevel.AF_LOG_LEVEL_TRACE;
            default:
                return LogLevel.AF_LOG_LEVEL_DEBUG;
        }
    }
}
export var LogLevel;
(function (s44) {
    s44[s44["AF_LOG_LEVEL_NONE"] = 0] = "AF_LOG_LEVEL_NONE";
    s44[s44["AF_LOG_LEVEL_FATAL"] = 8] = "AF_LOG_LEVEL_FATAL";
    s44[s44["AF_LOG_LEVEL_ERROR"] = 16] = "AF_LOG_LEVEL_ERROR";
    s44[s44["AF_LOG_LEVEL_WARNING"] = 24] = "AF_LOG_LEVEL_WARNING";
    s44[s44["AF_LOG_LEVEL_INFO"] = 32] = "AF_LOG_LEVEL_INFO";
    s44[s44["AF_LOG_LEVEL_DEBUG"] = 48] = "AF_LOG_LEVEL_DEBUG";
    s44[s44["AF_LOG_LEVEL_TRACE"] = 56] = "AF_LOG_LEVEL_TRACE";
})(LogLevel || (LogLevel = {}));
export var LogOption;
(function (r44) {
    r44[r44["FRAME_LEVEL_LOGGING_ENABLED"] = 1] = "FRAME_LEVEL_LOGGING_ENABLED";
})(LogOption || (LogOption = {}));
