import premierlibrary from 'libpremierlibrary.so';
import { AliPlayerGlobalSettings } from '../player/AliPlayerGlobalSettings';
import { ErrorInfo } from '../player/bean/ErrorInfo';
import { findErrorCodeByValue, PlayerErrorCode } from '../player/bean/PlayerErrorCode';
export const OLD_CODE_EADDED = -300;
export const OLD_CODE_ENOT_ENABLE = -301;
export class MediaLoader {
    static getInstance() {
        if (MediaLoader.sInstance == undefined) {
            MediaLoader.sInstance = new MediaLoader();
        }
        return MediaLoader.sInstance;
    }
    constructor() {
        this.onError = (h5, i5, j5) => {
            console.log('medialoader onError called, url: ' + h5 + " code: " + i5 + " msg " + j5);
            if (this.mOnLoadStatusListener != null) {
                this.mOnLoadStatusListener.onError(h5, i5, j5);
            }
            if (i5 != OLD_CODE_EADDED) {
                MediaLoader.getInstance().cancel(h5);
            }
        };
        this.onErrorV2 = (c5, d5, e5) => {
            console.log('medialoader onErrorV2 called, url: ' + c5 + " code: " + d5 + " msg " + e5);
            if (this.mOnLoadStatusListener != null) {
                let f5 = findErrorCodeByValue(d5);
                let g5 = new ErrorInfo();
                g5.setCode(f5);
                g5.setMsg(e5);
                this.mOnLoadStatusListener.onErrorV2(c5, g5);
            }
            if (d5 != PlayerErrorCode.MEDIALOADER_ERROR_ADDED) {
                MediaLoader.getInstance().cancel(c5);
            }
        };
        this.onCompleted = (b5) => {
            console.log('medialoader onCompleted called, url: ' + b5);
            if (this.mOnLoadStatusListener) {
                this.mOnLoadStatusListener.onCompleted(b5);
            }
        };
        this.onCanceled = (a5) => {
            console.log('medialoader onCanceled called, url: ' + a5);
            if (this.mOnLoadStatusListener) {
                this.mOnLoadStatusListener.onCancel(a5);
            }
        };
        premierlibrary.nMediaLoaderConstruct(this);
    }
    setOnLoadStatusListener(v4) {
        MediaLoader.getInstance().mOnLoadStatusListener = v4;
    }
    load(s4, t4) {
        let u4 = AliPlayerGlobalSettings.OnGetUrlHashCallback(s4);
        premierlibrary.nMediaLoaderLoad(s4, u4, t4);
    }
    loadWithBandWidth(o4, p4, q4) {
        let r4 = AliPlayerGlobalSettings.OnGetUrlHashCallback(o4);
        premierlibrary.nMediaLoaderLoadWithBandWidth(o4, r4, p4, q4);
    }
    loadWithResolution(k4, l4, m4) {
        let n4 = AliPlayerGlobalSettings.OnGetUrlHashCallback(k4);
        premierlibrary.nMediaLoaderLoadWithResolution(k4, n4, l4, m4);
    }
    cancel(i4) {
        if (i4 == undefined) {
            premierlibrary.nMediaLoaderCancelAll();
        }
        else {
            let j4 = AliPlayerGlobalSettings.OnGetUrlHashCallback(i4);
            premierlibrary.nMediaLoaderCancel(i4, j4);
        }
    }
    pause(g4) {
        let h4 = AliPlayerGlobalSettings.OnGetUrlHashCallback(g4);
        premierlibrary.nMediaLoaderPause(true, g4, h4);
    }
    resume(e4) {
        let f4 = AliPlayerGlobalSettings.OnGetUrlHashCallback(e4);
        premierlibrary.nMediaLoaderPause(false, e4, f4);
    }
}
