export class AVPLBase {
    constructor(l20, m20) {
        this.mNativePlayer = this.getNativePlayerWithContext(l20, m20);
        this.mPreRenderPlayer = this.getPrerenderPlayerWithContext(l20, m20);
        this.mListPlayer = this.createListPlayer(l20, m20, this.mNativePlayer.getNativeContextAddr(), this.mPreRenderPlayer.getNativeContextAddr());
    }
    getCurrentPlayer() {
        let k20 = this.getCurrentPlayerIndex();
        if (k20 == 1) {
            return this.mPreRenderPlayer;
        }
        else {
            return this.mNativePlayer;
        }
    }
    getCurrentPrerenderPlayer(j20) {
        if (j20 == 0) {
            return this.mNativePlayer;
        }
        else if (j20 == 1) {
            return this.mPreRenderPlayer;
        }
        return undefined;
    }
    getCorePlayer() {
        return this.mListPlayer;
    }
    getNativePlayer() {
        return this.mNativePlayer;
    }
    getPrerenderPlayer() {
        return this.mPreRenderPlayer;
    }
    removeSource(i20) {
        this.mListPlayer?.removeSource(i20);
    }
    clear() {
        this.mListPlayer?.clear();
    }
    getCurrentUid() {
        return this.mListPlayer?.getCurrentUid();
    }
    setMaxPreloadMemorySizeMB(h20) {
        this.mListPlayer?.setMaxPreloadMemorySizeMB(h20);
    }
    getMaxPreloadMemorySizeMB() {
        return this.mListPlayer?.getMaxPreloadMemorySizeMB();
    }
    SetMultiBitratesMode(g20) {
        this.mListPlayer?.SetMultiBitratesMode(g20);
    }
    GetMultiBitratesMode() {
        return this.mListPlayer?.GetMultiBitratesMode();
    }
    setPreloadCount(f20) {
        this.mListPlayer?.setPreloadCount(f20);
    }
    setPreloadScene(e20) {
        this.mListPlayer?.setPreloadScene(e20);
    }
    enablePreloadStrategy(c20, d20) {
        this.mListPlayer?.enablePreloadStrategy(c20, d20);
    }
    setPreloadStrategy(a20, b20) {
        this.mListPlayer?.setPreloadStrategyParam(a20, b20);
    }
    setPreloadCountWithPrevAndNext(y19, z19) {
        this.mListPlayer?.setPreloadCountWithPrevAndNext(y19, z19);
    }
    getNativeContextAddr() {
        return this.getCurrentPlayer()?.getNativeContextAddr();
    }
    prepare() {
        this.getCurrentPlayer().prepare();
    }
    start() {
        this.getCurrentPlayer()?.start();
    }
    pause() {
        this.getCurrentPlayer().pause();
    }
    stop() {
        this.getCurrentPlayer().stop();
    }
    setAutoPlay(x19) {
        this.getCurrentPlayer().setAutoPlay(x19);
    }
    setSurfaceId(w19) {
        this.getCurrentPlayer().setSurfaceId(w19);
    }
    setSpeed(v19) {
        this.getCurrentPlayer().setSpeed(v19);
    }
    setVolume(u19) {
        this.getCurrentPlayer().setVolume(u19);
    }
    getVolume() {
        return this.getCurrentPlayer().getVolume();
    }
    seekTo(s19, t19) {
        this.getCurrentPlayer().seekTo(s19, t19);
    }
    setStartTime(q19, r19) {
        this.getCurrentPlayer().setStartTime(q19, r19);
    }
    getDuration() {
        return this.getCurrentPlayer().getDuration();
    }
    getPlayedDuration() {
        return this.getCurrentPlayer().getPlayedDuration();
    }
    getCurrentPosition() {
        return this.getCurrentPlayer().getCurrentPosition();
    }
    getBufferedPosition() {
        return this.getCurrentPlayer().getBufferedPosition();
    }
    getPlayerStatus() {
        return this.getCurrentPlayer().getPlayerStatus();
    }
    enableHardwareDecoder(p19) {
        this.getCurrentPlayer().enableHardwareDecoder(p19);
    }
    release() {
        this.mListPlayer?.release();
        this.mNativePlayer?.release();
        this.mPreRenderPlayer?.release();
    }
    releaseAsync() {
        this.release();
    }
    setMute(o19) {
        this.getCurrentPlayer().setMute(o19);
    }
    isMuted() {
        return this.getCurrentPlayer().isMuted();
    }
    setScaleMode(n19) {
        this.getCurrentPlayer().setScaleMode(n19);
    }
    getScaleMode() {
        return this.getCurrentPlayer().getScaleMode();
    }
    setLoop(m19) {
        this.getCurrentPlayer().setLoop(m19);
    }
    isLoop() {
        return this.getCurrentPlayer().isLoop();
    }
    getVideoWidth() {
        return this.getCurrentPlayer().getVideoWidth();
    }
    getVideoHeight() {
        return this.getCurrentPlayer().getVideoHeight();
    }
    getVideoRotation() {
        return this.getCurrentPlayer().getVideoRotation();
    }
    reload() {
        this.getCurrentPlayer().reload();
    }
    setRotateMode(l19) {
        this.getCurrentPlayer().setRotateMode(l19);
    }
    getRotateMode() {
        return this.getCurrentPlayer().getRotateMode();
    }
    setMirrorMode(k19) {
        this.getCurrentPlayer().setMirrorMode(k19);
    }
    getMirrorMode() {
        return this.getCurrentPlayer().getMirrorMode();
    }
    setAlphaRenderMode(j19) {
        this.getCurrentPlayer().setAlphaRenderMode(j19);
    }
    getAlphaRenderMode() {
        return this.getCurrentPlayer().getAlphaRenderMode();
    }
    setVideoBackgroundColor(i19) {
        this.getCurrentPlayer().setVideoBackgroundColor(i19);
    }
    getSpeed() {
        return this.getCurrentPlayer().getSpeed();
    }
    isAutoPlay() {
        return this.getCurrentPlayer().isAutoPlay();
    }
    setConfig(h19) {
        if (this.mNativePlayer != null) {
            this.mNativePlayer.setConfig(h19);
        }
        if (this.mPreRenderPlayer != null) {
            this.mPreRenderPlayer.setConfig(h19);
        }
    }
    getConfig() {
        return this.getCurrentPlayer().getConfig();
    }
    setPlayerScene(g19) {
        this.getCurrentPlayer().setPlayerScene(g19);
    }
    setOption(e19, f19) {
        this.getCurrentPlayer().setOption(e19, f19);
    }
    setOptionNum(c19, d19) {
        this.getCurrentPlayer().setOptionNum(c19, d19);
    }
    getOption(b19) {
        return this.getCurrentPlayer().getOption(b19);
    }
    selectTrack(a19) {
        this.getCurrentPlayer()?.selectTrack(a19);
    }
    switchStream(z18) {
        this.getCurrentPlayer()?.switchStream(z18);
    }
    getMediaInfo() {
        return this.getCurrentPlayer()?.getMediaInfo();
    }
    getSubMediaInfo() {
        return this.getCurrentPlayer()?.getSubMediaInfo();
    }
    currentTrack(y18) {
        return this.getCurrentPlayer()?.currentTrack(y18);
    }
    addExtSubtitle(x18) {
        this.getCurrentPlayer()?.addExtSubtitle(x18);
    }
    selectExtSubtitle(v18, w18) {
        this.getCurrentPlayer()?.selectExtSubtitle(v18, w18);
    }
    setStreamDelay(t18, u18) {
        this.getCurrentPlayer()?.setStreamDelay(t18, u18);
    }
    setMaxAccurateSeekDelta(s18) {
        this.getCurrentPlayer()?.setMaxAccurateSeekDelta(s18);
    }
    setCacheConfig(r18) {
        this.getCurrentPlayer()?.setCacheConfig(r18);
    }
    setIPResolveType(q18) {
        this.getCurrentPlayer()?.setIPResolveType(q18);
    }
    setFastStart(p18) {
        this.getCurrentPlayer()?.setFastStart(p18);
    }
    snapShot() {
        this.getCurrentPlayer()?.snapShot();
    }
    clearScreen() {
        this.getCurrentPlayer()?.clearScreen();
    }
    getCacheFilePathByUrl(o18) {
        return this.getCurrentPlayer()?.getCacheFilePathByUrl(o18) || '';
    }
    getCacheFilePathByVid(k18, l18, m18, n18) {
        return this.getCurrentPlayer()?.getCacheFilePathByVid(k18, l18, m18, n18) || '';
    }
    getPropertyString(j18) {
        return this.getCurrentPlayer()?.getPropertyString(j18) || '';
    }
    setDefaultBandWidth(i18) {
        this.getCurrentPlayer()?.setDefaultBandWidth(i18);
    }
    setDefaultResolution(h18) {
        this.getCurrentPlayer()?.setDefaultResolution(h18);
    }
    sendCustomEvent(g18) {
        this.getCurrentPlayer()?.sendCustomEvent(g18);
    }
    setVideoTag(f18) {
        this.getCurrentPlayer()?.setVideoTag(f18);
    }
    setUserData(e18) {
        this.getCurrentPlayer()?.setUserData(e18);
    }
    setTraceId(d18) {
        this.getCurrentPlayer()?.setTraceId(d18);
    }
    getUserData() {
        return this.getCurrentPlayer()?.getUserData() || '';
    }
    setOnPreparedListener(c18) {
        this.getCurrentPlayer().setOnPreparedListener(c18);
    }
    setOnInfoListener(b18) {
        this.getCurrentPlayer().setOnInfoListener(b18);
    }
    setOnRenderingStartListener(a18) {
        this.getCurrentPlayer().setOnRenderingStartListener(a18);
    }
    setOnStateChangedListener(z17) {
        this.getCurrentPlayer().setOnStateChangedListener(z17);
    }
    setOnCompletionListener(y17) {
        this.getCurrentPlayer().setOnCompletionListener(y17);
    }
    setOnLoadingStatusListener(x17) {
        this.getCurrentPlayer().setOnLoadingStatusListener(x17);
    }
    setOnAVNotSyncStatusListener(w17) {
        this.getCurrentPlayer()?.setOnAVNotSyncStatusListener(w17);
    }
    setOnErrorListener(v17) {
        this.getCurrentPlayer().setOnErrorListener(v17);
    }
    setOnVideoSizeChangedListener(u17) {
        this.getCurrentPlayer().setOnVideoSizeChangedListener(u17);
    }
    setOnSeekCompleteListener(t17) {
        this.getCurrentPlayer().setOnSeekCompleteListener(t17);
    }
    setOnSubtitleDisplayListener(s17) {
        this.getCurrentPlayer().setOnSubtitleDisplayListener(s17);
    }
    setOnVideoRenderedListener(r17) {
        this.getCurrentPlayer().setOnVideoRenderedListener(r17);
    }
    setOnAudioInterruptEventListener(q17) {
        this.getCurrentPlayer().setOnAudioInterruptEventListener(q17);
    }
    setOnSubTrackReadyListener(p17) {
        this.getCurrentPlayer()?.setOnSubTrackReadyListener(p17);
    }
    setOnTrackReadyListener(o17) {
        this.getCurrentPlayer()?.setOnTrackReadyListener(o17);
    }
    setOnTrackChangedListener(n17) {
        this.getCurrentPlayer()?.setOnTrackChangedListener(n17);
    }
    setOnSnapShotListener(m17) {
        this.getCurrentPlayer()?.setOnSnapShotListener(m17);
    }
    setOnSeiDataListener(l17) {
        this.getCurrentPlayer()?.setOnSeiDataListener(l17);
    }
    setOnStreamSwitchedListener(k17) {
        this.getCurrentPlayer()?.setOnStreamSwitchedListener(k17);
    }
}
