import { LiveTimeUpdater } from "../liveshift/LiveTimeUpdater";
import { AVPBase } from "./AVPBase";
import { OhosSaasPlayer } from "./nativeclass/OhosSaasPlayer";
import { UrlSource } from "./source/UrlSource";
import url from "@ohos.url";
import { prepared, started } from "../player/IPlayer";
const onTimeShiftUpdaterListenerMap = new WeakMap();
const liveOnPreparedListenerMap = new WeakMap();
const liveOnLoadingStatusListenerMap = new WeakMap();
const liveOnStateChangedListenerMap = new WeakMap();
export class ApsaraLiveShiftPlayer extends AVPBase {
    constructor(s9, t9) {
        super(s9, t9);
        this.status = -1;
        this.statusWhenSeek = -1;
        this.liveSeekToTime = -1;
        this.liveSeekOffset = -1;
        this.mLiveShiftSource = null;
        this.mLiveTimeUpdater = null;
        this.mOutOnTimeShiftUpdaterListener = null;
        this.mInnerOnTimeShiftUpdaterListener = new InnerTimeShiftUpdateListener(this);
        this.mOutLiveOnPreparedListener = null;
        this.mInnerLiveOnPreparedListener = new InnerLivePreparedListener(this);
        this.mOutLiveOnStateChangedListener = null;
        this.mInnerLiveOnStateChangedListener = new InnerLiveStateChangedListener(this);
        this.mOutLiveOnLoadingStatusListener = null;
        this.mInnerLiveOnLoadingStatusListener = new InnerLiveLoadingStatusListener(this);
        this.mOutLiveSeekLiveCompletionListener = null;
        onTimeShiftUpdaterListenerMap.set(this, this.mInnerOnTimeShiftUpdaterListener);
        liveOnPreparedListenerMap.set(this, this.mInnerLiveOnPreparedListener);
        liveOnLoadingStatusListenerMap.set(this, this.mInnerLiveOnLoadingStatusListener);
        liveOnStateChangedListenerMap.set(this, this.mInnerLiveOnStateChangedListener);
    }
    createAlivcMediaPlayer(q9) {
        let r9 = new OhosSaasPlayer(q9);
        return r9;
    }
    setLiveShiftDataSource(n9) {
        this.mLiveShiftSource = n9;
        let o9 = new UrlSource();
        o9.setUri(this.mLiveShiftSource.getUrl());
        let p9 = this.getCorePlayer();
        if (p9 instanceof OhosSaasPlayer) {
            p9.setUrlDataSource(o9);
        }
    }
    getCurrentLiveTime() {
        if (this.mLiveTimeUpdater) {
            return this.mLiveTimeUpdater.getLiveTime();
        }
        return 0;
    }
    getCurrentTime() {
        if (this.mLiveTimeUpdater) {
            return this.mLiveTimeUpdater.getPlayTime();
        }
        return 0;
    }
    seekToLiveTime(f9) {
        if (this.status == ApsaraLiveShiftPlayer.SeekLive) {
            return;
        }
        if (this.mLiveShiftSource == null) {
            return;
        }
        this.statusWhenSeek = this.status;
        this.status = ApsaraLiveShiftPlayer.SeekLive;
        this.liveSeekToTime = f9;
        this.liveSeekOffset = this.getCurrentLiveTime() - this.liveSeekToTime;
        if (this.liveSeekToTime < 0) {
            this.liveSeekToTime = 0;
            this.liveSeekToTime = this.getCurrentLiveTime();
        }
        let g9 = this.mLiveShiftSource?.getUrl();
        if (this.liveSeekToTime > 0 && this.liveSeekOffset > 0) {
            let h9 = url.URL.parseURL(g9);
            let i9 = new url.URLParams(h9.search);
            let j9 = i9.entries();
            let k9 = Array.from(j9);
            if (g9.endsWith("?") || g9.endsWith("&")) {
                g9 += ("lhs_offset_unix_s_0=" + this.liveSeekOffset + "&lhs_start=1&aliyunols=on");
            }
            else {
                if (k9.length <= 0) {
                    g9 += ("?lhs_offset_unix_s_0=" + this.liveSeekOffset + "&lhs_start=1&aliyunols=on");
                }
                else {
                    g9 += ("&lhs_offset_unix_s_0=" + this.liveSeekOffset + "&lhs_start=1&aliyunols=on");
                }
            }
            let l9 = new UrlSource();
            l9.setUri(g9);
            let m9 = this.getCorePlayer();
            if (m9 instanceof OhosSaasPlayer) {
                m9.setUrlDataSource(l9);
                m9.prepare();
            }
        }
    }
    start() {
        super.start();
        if (this.mLiveTimeUpdater != null) {
            this.mLiveTimeUpdater.resumeUpdater();
        }
    }
    pause() {
        super.pause();
        this.mLiveTimeUpdater?.pauseUpdater();
    }
    stop() {
        super.stop();
        this.mLiveTimeUpdater?.stopUpdater();
    }
    onUpdater(c9, d9, e9) {
        console.info(ApsaraLiveShiftPlayer.tag + `onUpdater, currentTime: ${c9}, shiftStartTime: ${d9}, shiftEndTime: ${e9}`);
        if (this.mOutOnTimeShiftUpdaterListener) {
            this.mOutOnTimeShiftUpdaterListener.onUpdater(c9, d9, e9);
        }
    }
    onPrepared() {
        console.info(ApsaraLiveShiftPlayer.tag + " onPrepared");
        if (this.mLiveTimeUpdater != null) {
            this.mLiveTimeUpdater.stopUpdater();
        }
        else {
            if (this.mLiveShiftSource) {
                this.mLiveTimeUpdater = new LiveTimeUpdater(this.mLiveShiftSource);
                this.mLiveTimeUpdater.setUpdaterListener(this.mInnerOnTimeShiftUpdaterListener);
            }
        }
        let b9 = this.getConfig();
        if (b9 != undefined) {
            this.mLiveTimeUpdater?.setConfig(b9);
            this.mLiveTimeUpdater?.setStartPlayTime(this.liveSeekToTime);
            this.mLiveTimeUpdater?.startUpdater();
        }
        if (this.status == ApsaraLiveShiftPlayer.SeekLive) {
            this.status = prepared;
            if (this.status == started) {
                this.start();
            }
            else {
                if (this.isAutoPlay()) {
                    this.mLiveTimeUpdater?.resumeUpdater();
                }
                else {
                    this.mLiveTimeUpdater?.pauseUpdater();
                }
            }
            if (this.mOutLiveSeekLiveCompletionListener != null) {
                console.info(ApsaraLiveShiftPlayer.tag + ` onSeekLiveCompletion, playTime: ${this.liveSeekToTime}`);
                this.mOutLiveSeekLiveCompletionListener.onSeekLiveCompletion(this.liveSeekToTime);
            }
            this.liveSeekToTime = -1;
        }
        else {
            this.status = prepared;
            if (this.mOutLiveOnPreparedListener != null) {
                this.mOutLiveOnPreparedListener.onPrepared();
            }
        }
    }
    onStateChanged(a9) {
        console.info(ApsaraLiveShiftPlayer.tag + " onStateChanged, newState: " + a9);
        if (a9 != prepared) {
            this.status = a9;
        }
        if (this.mOutLiveOnStateChangedListener != null) {
            this.mOutLiveOnStateChangedListener.onStateChanged(a9);
        }
    }
    onLoadingBegin() {
        console.info(ApsaraLiveShiftPlayer.tag + " onLoadingBegin");
        if (this.mLiveTimeUpdater != null) {
            this.mLiveTimeUpdater.pauseUpdater();
        }
        if (this.mOutLiveOnLoadingStatusListener != null) {
            this.mOutLiveOnLoadingStatusListener.onLoadingBegin();
        }
    }
    onLoadingProgress(y8, z8) {
        console.info(ApsaraLiveShiftPlayer.tag + " onLoadingProgress, percent: " + y8);
        if (this.mOutLiveOnLoadingStatusListener != null) {
            this.mOutLiveOnLoadingStatusListener.onLoadingProgress(y8, z8);
        }
    }
    onLoadingEnd() {
        console.info(ApsaraLiveShiftPlayer.tag + " onLoadingEnd");
        if (this.mLiveTimeUpdater != null) {
            this.mLiveTimeUpdater.resumeUpdater();
        }
        if (this.mOutLiveOnLoadingStatusListener != null) {
            this.mOutLiveOnLoadingStatusListener.onLoadingEnd();
        }
    }
    setOnTimeShiftUpdaterListener(x8) {
        this.mOutOnTimeShiftUpdaterListener = x8;
    }
    setOnSeekLiveCompletionListener(w8) {
        this.mOutLiveSeekLiveCompletionListener = w8;
    }
    setOnStateChangedListener(v8) {
        this.mOutLiveOnStateChangedListener = v8;
        super.setOnStateChangedListener(this.mInnerLiveOnStateChangedListener);
    }
    setOnPreparedListener(u8) {
        this.mOutLiveOnPreparedListener = u8;
        super.setOnPreparedListener(this.mInnerLiveOnPreparedListener);
    }
    setOnLoadingStatusListener(t8) {
        this.mOutLiveOnLoadingStatusListener = t8;
        super.setOnLoadingStatusListener(this.mInnerLiveOnLoadingStatusListener);
    }
}
ApsaraLiveShiftPlayer.tag = "ApsaraLiveShiftPlayer";
ApsaraLiveShiftPlayer.SeekLive = 10;
class InnerTimeShiftUpdateListener {
    constructor(s8) {
        this.avPlayerRef = s8;
    }
    onUpdater(p8, q8, r8) {
        console.log(`currentTime: ${p8}}, shiftStartTime: ${q8}, shiftEndTime: ${r8} `);
        if (this.avPlayerRef != null) {
            this.avPlayerRef.onUpdater(p8, q8, r8);
        }
    }
}
class InnerLivePreparedListener {
    constructor(o8) {
        this.avPlayerRef = o8;
    }
    onPrepared() {
        if (this.avPlayerRef != null) {
            this.avPlayerRef.onPrepared();
        }
    }
}
class InnerLiveStateChangedListener {
    constructor(n8) {
        this.avPlayerRef = n8;
    }
    onStateChanged(m8) {
        if (this.avPlayerRef != null) {
            this.avPlayerRef.onStateChanged(m8);
        }
    }
}
class InnerLiveLoadingStatusListener {
    constructor(l8) {
        this.avPlayerRef = l8;
    }
    onLoadingBegin() {
        if (this.avPlayerRef != null) {
            this.avPlayerRef.onLoadingBegin();
        }
    }
    onLoadingProgress(j8, k8) {
        if (this.avPlayerRef != null) {
            this.avPlayerRef.onLoadingProgress(j8, k8);
        }
    }
    onLoadingEnd() {
        if (this.avPlayerRef != null) {
            this.avPlayerRef.onLoadingEnd();
        }
    }
    ;
}
