import { UrlVideoListPlayer } from './UrlVideoListPlayer';
import { Log } from '../utils/Log';
import { ApsaraVideoPlayer } from './ApsaraVideoPlayer';
import { OhosUrlListPlayer } from './nativeclass/OhosUrlListPlayer';
import { LiveSts } from './source/LiveSts';
import { VidSts } from './source/VidSts';
import { VidAuth } from './source/VidAuth';
import { VidMps } from './source/VidMps';
import { StsInfo } from './source/StsInfo';
import { OhosSaasListPlayer } from './nativeclass/OhosSaasListPlayer';
export class ApsaraVideoListPlayer extends UrlVideoListPlayer {
    constructor(s10, t10) {
        super(s10, t10);
        this.mmLog = new Log("NativePlayerBase_ApsaraVideListPlayer");
        this.mSaasVidePlayer = null;
        this.mSaaSPrerenderPlayer = null;
    }
    createListPlayer(o10, p10, q10, r10) {
        return new OhosSaasListPlayer(o10, q10, r10, true);
    }
    getNativePlayerWithContext(m10, n10) {
        if (this.mSaasVidePlayer == null) {
            this.mSaasVidePlayer = new ApsaraVideoPlayer(m10, n10);
        }
        return this.mSaasVidePlayer;
    }
    getPrerenderPlayerWithContext(k10, l10) {
        if (this.mSaaSPrerenderPlayer == null) {
            this.mSaaSPrerenderPlayer = new ApsaraVideoPlayer(k10, l10);
        }
        return this.mSaaSPrerenderPlayer;
    }
    getCurrentPlayerIndex() {
        let j10 = super.getCorePlayer();
        if (j10 instanceof OhosUrlListPlayer) {
            this.mmLog.info("getCurrentPlayerIndex");
            return j10.getCurrentPlayerIndex();
        }
        return 0;
    }
    stop() {
        super.stop();
        let i10 = super.getCorePlayer();
        if (i10 instanceof OhosUrlListPlayer) {
            this.mmLog.info("stop");
            i10.stop();
        }
    }
    getPreRenderPlayer() {
        let g10 = super.getCorePlayer();
        if (g10 instanceof OhosUrlListPlayer) {
            this.mmLog.info("getPreRenderPlayer");
            let h10 = g10.getPreRenderPlayerIndex();
            return this.getCurrentPrerenderPlayer(h10);
        }
        return undefined;
    }
    setVidAuthDataSource(e10) {
        let f10 = super.getCorePlayer();
        if (f10 instanceof ApsaraVideoPlayer) {
            if (e10 instanceof VidAuth) {
                f10.setVidAuthDataSource(e10);
            }
        }
    }
    setVidStsDataSource(c10) {
        let d10 = super.getCorePlayer();
        if (d10 instanceof ApsaraVideoPlayer) {
            if (c10 instanceof VidSts) {
                d10.setVidStsDataSource(c10);
            }
        }
    }
    setVidMpsDataSource(a10) {
        let b10 = super.getCorePlayer();
        if (b10 instanceof ApsaraVideoPlayer) {
            if (a10 instanceof VidMps) {
                b10.setVidMpsDataSource(a10);
            }
        }
    }
    setLiveStsDataSource(y9) {
        let z9 = super.getCorePlayer();
        if (z9 instanceof ApsaraVideoPlayer) {
            if (y9 instanceof LiveSts) {
                z9.setLiveStsDataSource(y9);
            }
        }
    }
    updateVidAuth(w9) {
        let x9 = super.getCorePlayer();
        if (x9 instanceof ApsaraVideoPlayer) {
            if (w9 instanceof VidAuth) {
                x9.updateVidAuth(w9);
            }
        }
    }
    updateStsInfo(u9) {
        let v9 = super.getCorePlayer();
        if (v9 instanceof ApsaraVideoPlayer) {
            if (u9 instanceof StsInfo) {
                v9.updateStsInfo(u9);
            }
        }
    }
}
