import premierlibrary from 'libpremierlibrary.so';
export class HlsKeyGenerator {
    static getInstance() {
        if (HlsKeyGenerator.instance == undefined) {
            HlsKeyGenerator.instance = new HlsKeyGenerator();
        }
        return HlsKeyGenerator.instance;
    }
    static setOnKeyGenerateListener(q21) {
        HlsKeyGenerator.getInstance().mOnKeyGenerateListener = q21;
    }
    constructor() {
        this.mOutKey = "default-key";
        this.getHlsOutKey = () => {
            return HlsKeyGenerator.getInstance().mOutKey;
        };
        this.onHlsKeyInfoInit = (n21, o21, p21) => {
            console.log('onHlsKeyInfoInit called.');
            if (this.mOnKeyGenerateListener != null) {
                this.mOnKeyGenerateListener.onHlsKeyInfoInit(n21, o21, p21);
            }
        };
        this.getHlsKey = (k21, l21) => {
            console.log('ongetHlsKey called.');
            if (this.mOnKeyGenerateListener != null) {
                let m21 = this.mOnKeyGenerateListener.getHlsKey(k21, l21);
                this.mOutKey = m21;
                console.log("get hlsKey, key: " + m21);
                return m21;
            }
            return "";
        };
        this.getHlsKeyInternal = () => {
            if (this.mOutKey) {
                return this.mOutKey;
            }
            return "";
        };
        premierlibrary.nHlsGenConstruct(this);
    }
}
