import { AVPLBase } from './AVPLBase';
import { Log } from '../utils/Log';
import { UrlVideoPlayer } from './UrlVideoPlayer';
import { OhosUrlListPlayer } from './nativeclass/OhosUrlListPlayer';
export class UrlVideoListPlayer extends AVPLBase {
    constructor(y41, z41) {
        super(y41, z41);
        this.mLog = new Log("NativePlayerBase_UrlVideoListPlayer");
        this.mUrlVideoPlayer = null;
        this.mUrlPrerenderPlayer = null;
    }
    createListPlayer(u41, v41, w41, x41) {
        return new OhosUrlListPlayer(u41, w41, x41, false);
    }
    getNativePlayerWithContext(s41, t41) {
        if (this.mUrlVideoPlayer == null) {
            this.mUrlVideoPlayer = new UrlVideoPlayer(s41, t41);
        }
        return this.mUrlVideoPlayer;
    }
    getPrerenderPlayerWithContext(q41, r41) {
        if (this.mUrlPrerenderPlayer == null) {
            this.mUrlPrerenderPlayer = new UrlVideoPlayer(q41, r41);
        }
        return this.mUrlPrerenderPlayer;
    }
    getCurrentPlayerIndex() {
        let p41 = super.getCorePlayer();
        if (p41 instanceof OhosUrlListPlayer) {
            this.mLog.info("getCurrentPlayerIndex");
            return p41.getCurrentPlayerIndex();
        }
        return -1;
    }
    getPreRenderPlayer() {
        let n41 = super.getCorePlayer();
        if (n41 instanceof OhosUrlListPlayer) {
            this.mLog.info("getPreRenderPlayer");
            let o41 = n41.getPreRenderPlayerIndex();
            return this.getCurrentPrerenderPlayer(o41);
        }
        return undefined;
    }
    addUrl(k41, l41) {
        let m41 = super.getCorePlayer();
        if (m41 instanceof OhosUrlListPlayer) {
            this.mLog.info("addUrl = " + k41 + " , uid = " + l41);
            m41.addUrl(k41, l41);
        }
    }
    moveToNext() {
        let j41 = super.getCorePlayer();
        if (j41 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveToNext");
            return j41.moveToNext(false);
        }
        return false;
    }
    moveToNextWithPrerendered() {
        let i41 = super.getCorePlayer();
        if (i41 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveToNextWithPrerendered");
            return i41.moveToNext(true);
        }
        return false;
    }
    moveToPrev() {
        let h41 = super.getCorePlayer();
        if (h41 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveToPrev");
            return h41.moveToPrev();
        }
        return false;
    }
    moveTo(f41) {
        let g41 = super.getCorePlayer();
        if (g41 instanceof OhosUrlListPlayer) {
            this.mLog.info("moveTo");
            return g41.moveTo(f41);
        }
        return false;
    }
    setUrlDataSource(d41) {
        let e41 = super.getNativePlayer();
        if (e41.setUrlDataSource !== undefined) {
            e41.setUrlDataSource(d41);
        }
    }
}
