export class VidPlayerConfigGen {
    constructor() {
        this.configMap = new Map();
    }
    addPlayerConfigNumber(q42, r42) {
        if (q42 != null) {
            this.configMap.set(q42, r42);
        }
    }
    addPlayerConfigString(o42, p42) {
        if (o42 != null) {
            this.configMap.set(o42, p42);
        }
    }
    setPreviewTime(n42) {
        this.addPlayerConfigNumber("PreviewTime", n42);
    }
    setEncryptType(m42) {
        if (m42 == EncryptType.AliyunVodEncryption) {
            this.addPlayerConfigString("EncryptType", "AliyunVoDEncryption");
        }
        else if (m42 == EncryptType.HLSEncryption) {
            this.addPlayerConfigString("EncryptType", "HLSEncryption");
        }
        else if (m42 == EncryptType.Unencrypted) {
            this.addPlayerConfigString("EncryptType", "Unencrypted");
        }
    }
    setMtsHlsUriToken(l42) {
        this.addPlayerConfigString("MtsHlsUriToken", l42);
    }
    genConfig() {
        let h42 = {};
        if (this.configMap.size == 0) {
            return "";
        }
        this.configMap.forEach((j42, k42) => {
            if (k42 != undefined && j42 != undefined) {
                h42[k42] = j42;
            }
        });
        return JSON.stringify(h42);
    }
}
export var EncryptType;
(function (g42) {
    g42[g42["Unencrypted"] = 0] = "Unencrypted";
    g42[g42["AliyunVodEncryption"] = 1] = "AliyunVodEncryption";
    g42[g42["HLSEncryption"] = 2] = "HLSEncryption";
})(EncryptType || (EncryptType = {}));
