"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getObjectKeysWithProtoChain = exports.toStringWithZeroSign = exports.falsey = exports.whiteSpace = exports.tagName = void 0;
/**
 * 获取指定对象的对象名称，例如
 * const a = 10;
 * getObjTagName(a); // => [object Number]
 * @param object
 */
function tagName(object) {
    if (object === null) {
        return '[object Null]';
    }
    if (object === undefined) {
        return '[object Undefined]';
    }
    var toString = Object.prototype.toString;
    return toString.apply(object);
}
exports.tagName = tagName;
exports.whiteSpace = [' ', '\t', '\x0b', '\f', '\xa0', '\ufeff', '\n', '\r', '\u2028', '\u2029', '\u1680',
    '\u180e', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2007', '\u2008', '\u2009',
    '\u200a', '\u202f', '\u205f', '\u3000',
];
/**
 * 虚值数组
 */
exports.falsey = [null, undefined, false, 0, NaN, ''];
// 将value转为字符串，但保留0的符号位，-0以及Object(-0)将转为'-0'，同时也保留symbol
var toStringWithZeroSign = function (value) {
    if (typeof value === 'symbol') {
        return value;
    }
    if (Object.is(-0, value)
        || (value instanceof Number && Object.is(-0, Number(value)))) {
        return '-0';
    }
    return String(value);
};
exports.toStringWithZeroSign = toStringWithZeroSign;
/**
 * 获得obj及其原型链上的所有可枚举属性
 * @param obj
 * @return obj及其原型链上所有属性组成的数组
 */
function getObjectKeysWithProtoChain(obj) {
    var keys = [];
    var tmpObj = obj;
    while (tmpObj !== undefined && tmpObj !== null) {
        keys = keys.concat(Object.keys(tmpObj));
        tmpObj = Object.getPrototypeOf(tmpObj);
    }
    return __spreadArray([], __read(new Set(keys)), false);
}
exports.getObjectKeysWithProtoChain = getObjectKeysWithProtoChain;
