"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isPositiveInteger = exports.isNumberic = void 0;
var utils_1 = require("./common/utils");
function isNumber(object) {
    var objTag = (0, utils_1.tagName)(object);
    return objTag === '[object Number]';
}
exports.default = isNumber;
/**
 * 判断指定的字符串是否是数字。-0 和 0 都是数字
 * @param str
 * @example
 * console.log(isNumeric('123'));
 * // ==> true
 * console.log(isNumeric('123.45'));
 * // ==> true
 * console.log(isNumeric('-123.45'));
 * // ==> true
 * console.log(isNumeric('abc'));
 * // ==> false
 */
function isNumberic(str) {
    return /^-?\d+(\.\d+)?$/.test(str);
}
exports.isNumberic = isNumberic;
/**
 * 判断指定的字符串是否是由10进制阿拉伯数字组成的正整数。
 * -0 不是正整数，0是正整数。
 * <strong>请注意，8进制、16进制字符串将被识别成字符串，不是正整数。</strong>
 *
 * @param str 待判断的字符串
 * @example
 * console.log(isPositiveInteger('123'));
 * // ==> true
 * console.log(isPositiveInteger('0'));
 * // ==> true
 * console.log(isPositiveInteger('-0'));
 * // ==> false
 * console.log(isPositiveInteger('123.45'));
 * // ==> false
 * console.log(isPositiveInteger('-123'));
 * // ==> false
 * console.log(isPositiveInteger('abc'));
 * // ==> false
 * console.log(isPositiveInteger('0xAF'));
 * // ==> false
 */
function isPositiveInteger(str) {
    if (str === '-0') {
        return false;
    }
    if (str === '0') {
        return true;
    }
    return /^[1-9]\d*$/.test(str);
}
exports.isPositiveInteger = isPositiveInteger;
